#include <Application.h>
#include <Entry.h>
#include <Path.h>
#include <File.h>
#include <Volume.h>
#include <stdio.h>

#include "CommonPool.h"
#include "History.h"
#include "MyClipBoard.h"
#include "VMSystem.h"

History Hist;

/*******************************************************
*   
*******************************************************/
History::History()
{
}

/*******************************************************
*   
*******************************************************/
void History::Init()
{
	app_info info;
	be_app->GetAppInfo(&info);

	// set up the temporary disk cache for the history
	// check some stuff and get it readu to go
	BString str;
	str = Prefs.temp_dir;
	str << "/SampleStudioUndo";
	str << info.thread;						// make the file unique
   
	BPath path;
	path.SetTo(str.String());
   
	HistoryFile = new BFile(path.Path(), B_READ_WRITE|B_CREATE_FILE|B_ERASE_FILE);//|B_FAIL_IF_EXISTS
	if(HistoryFile->InitCheck() != B_OK){
		// No file ... no undo i gess
	}else{
		// good to go
	}
   
	BEntry e(path.Path());
	e.GetRef(&file_ref);
	
	m_undo = false;
	m_redo = false;
   
	if((histSem = create_sem(1, "History Sem")) < 0){
//		debugger(CREATE_SEM_FAIL_MSG);
	}
}

/*******************************************************
*   
*******************************************************/
History::~History(){
	if(HistoryFile){
		delete HistoryFile;
	}

	BEntry e(&file_ref);
	e.Remove();
	delete_sem(histSem);
}

/*******************************************************
*   
*******************************************************/
bool History::Save(uint32 action, uint32 start, uint32 end){
	if (Pool.size == 0)	return false;
	acquire_sem(histSem);
   
	BVolume vol(file_ref.device);
	if(vol.FreeBytes() < ((end-start)*4+(Prefs.keep_free*1024*1224))){
		(new BAlert(NULL,Language.get("UNDO_ERROR"),Language.get("OK")))->Go();
		release_sem(histSem);
		return false;
	}
   
	HistoryFile->Seek(0, SEEK_SET);
	uint32 size = (end-start+1)*4*Pool.sample_type;
	
	switch(action){
	case H_PASTE:
		HistoryFile->Write(&action,sizeof(&action));
		HistoryFile->Write(&start,sizeof(&start));
		HistoryFile->Write(&end,sizeof(&end));
		HistoryFile->Write(&Pool.l_pointer,sizeof(&Pool.l_pointer));
		HistoryFile->Write(&Pool.r_pointer,sizeof(&Pool.r_pointer));
		break;
	case H_FULL:
		HistoryFile->Write(&action,sizeof(&action));
		HistoryFile->Write(&Pool.selection,sizeof(&Pool.selection));
		HistoryFile->Write(&end,sizeof(&end));
		HistoryFile->Write(&Pool.pointer,sizeof(&Pool.pointer));
		HistoryFile->Write(&Pool.l_pointer,sizeof(&Pool.l_pointer));
		HistoryFile->Write(&Pool.r_pointer,sizeof(&Pool.r_pointer));
		HistoryFile->Write(&Pool.r_sel_pointer,sizeof(&Pool.r_sel_pointer));	// needed for cut
		HistoryFile->Write(&Pool.sample_bits,sizeof(&Pool.sample_bits));
		HistoryFile->Write(&Pool.frequency,sizeof(&Pool.frequency));
		HistoryFile->Write(&Pool.sample_type,sizeof(&Pool.sample_type));
		HistoryFile->Write(&Pool.m_format,sizeof(&Pool.m_format));

		if (size < VM_BLOCK_SIZE){					// files smaller than 256Kb without progressBar
			VM.ReadBlockAt( 0, (float*)VM.buffer, size/4 );
			HistoryFile->Write( VM.buffer, size);
		}else{
			Pool.StartProgress(Language.get("SAVE_UNDO"), size);
			VM.SetPointer(0);
			while(size>=VM_BLOCK_SIZE){
				VM.ReadBlock( (float*)VM.buffer, VM_BLOCK_SIZE/4 );
				HistoryFile->Write( VM.buffer, VM_BLOCK_SIZE);
				size-=VM_BLOCK_SIZE;
				Pool.ProgressUpdate( VM_BLOCK_SIZE );
			}
			if (size) {
				VM.ReadBlock( (float*)VM.buffer, size/4 );
				HistoryFile->Write( VM.buffer, size);
			}
			Pool.HideProgress();
		}
		break;
	case H_REPLACE:			// just 1:1, like undo for a filter
	case H_DELETE:			// for cut, need an insert actio to restore
		HistoryFile->Write(&action,sizeof(&action));
		HistoryFile->Write(&Pool.selection,sizeof(&Pool.selection));
		HistoryFile->Write(&start,sizeof(&start));
		HistoryFile->Write(&end,sizeof(&end));
		HistoryFile->Write(&Pool.r_sel_pointer,sizeof(&Pool.r_sel_pointer));	// needed for cut
		HistoryFile->Write(&Pool.r_pointer,sizeof(&Pool.r_pointer));
		HistoryFile->Write(&Pool.l_pointer,sizeof(&Pool.l_pointer));
		HistoryFile->Write(&Pool.pointer,sizeof(&Pool.pointer));
		if (size < VM_BLOCK_SIZE){					// files smaller than 256Kb without progressBar
			VM.ReadBlockAt( start*Pool.sample_type, (float*)VM.buffer, size/4 );
			HistoryFile->Write( VM.buffer, size);
		}else{
			Pool.StartProgress(Language.get("SAVE_UNDO"), size);
			VM.SetPointer( start*Pool.sample_type );
			while(size>=VM_BLOCK_SIZE){
				VM.ReadBlock( (float*)VM.buffer, VM_BLOCK_SIZE/4 );
				HistoryFile->Write( VM.buffer, VM_BLOCK_SIZE);
				size-=VM_BLOCK_SIZE;
				Pool.ProgressUpdate( VM_BLOCK_SIZE );
			}
			if (size) {
				VM.ReadBlock( (float*)VM.buffer, size/4 );
				HistoryFile->Write( VM.buffer, size);
			}
			Pool.HideProgress();
		}
		break;
	}

	m_undo = true;

	release_sem(histSem);
	return true;
}

/*******************************************************
*   Restore. This also handles the ReDo data
*******************************************************/
bool History::Restore(){
	if (!m_undo)	return false;			// no undo data at all
	acquire_sem(histSem);

	Pool.mainWindow->PostMessage(TRANSPORT_STOP);	// can not use playing here

/*
 *	@TODO: Add Redo Code
*/

	uint32 action;
	HistoryFile->Seek(0, SEEK_SET);
	HistoryFile->Read(&action,sizeof(&action));

	uint32 start, end, size=0;

	if (action == H_DELETE || action == H_REPLACE){
		HistoryFile->Read(&Pool.selection,sizeof(&Pool.selection));
		HistoryFile->Read(&start,sizeof(&start));
		HistoryFile->Read(&end,sizeof(&end));
		HistoryFile->Read(&Pool.r_sel_pointer,sizeof(&Pool.r_sel_pointer));
		HistoryFile->Read(&Pool.r_pointer,sizeof(&Pool.r_pointer));
		HistoryFile->Read(&Pool.l_pointer,sizeof(&Pool.l_pointer));
		HistoryFile->Read(&Pool.pointer,sizeof(&Pool.pointer));
	}

	switch(action){
	case H_PASTE:
{		HistoryFile->Read(&start,sizeof(&start));
		HistoryFile->Read(&end,sizeof(&end));
		HistoryFile->Read(&Pool.l_pointer,sizeof(&Pool.l_pointer));
		HistoryFile->Read(&Pool.r_pointer,sizeof(&Pool.r_pointer));
		Pool.pointer = start;
		Pool.r_sel_pointer = end;
		Pool.selection = BOTH;
		bool old = Prefs.save_undo;
		Prefs.save_undo = false;
		ClipBoard.DoCut();
		Prefs.save_undo = old;
		Pool.selection = NONE;
}		break;
	case H_DELETE:			// for cut, need an insert actio to restore
{		// data needs to be inserted
		BVolume vol(file_ref.device);
		if(vol.FreeBytes() < ((end-start)*4+(Prefs.keep_free*1024*1224))){
			(new BAlert(NULL,Language.get("UNDO_ERROR"),Language.get("OK")))->Go();
			release_sem(histSem);
			return false;
		}
		if (Pool.r_pointer==Pool.size)			// if full view, keep full view
			Pool.r_pointer += (end - start +1);

		Pool.size += (end - start +1);
		VM.Insert( start*Pool.sample_type, (end - start +1)*Pool.sample_type );		// adjust size

}		// now read the file	
	case H_REPLACE:			// just 1:1, like undo for a filter, no sample_type change needed/possible
		size = (end-start+1)*4*Pool.sample_type;
		if (size < VM_BLOCK_SIZE){					// files smaller than 256Kb without progressBar
			HistoryFile->Read( VM.buffer, size);
			VM.WriteBlockAt( start*Pool.sample_type, (float*)VM.buffer, size/4 );
		}else{
			Pool.StartProgress(Language.get("RESTORE_UNDO"), size);
			VM.SetPointer( start*Pool.sample_type );
			while(size>=VM_BLOCK_SIZE){
				HistoryFile->Read( VM.buffer, VM_BLOCK_SIZE);
				VM.WriteBlock( (float*)VM.buffer, VM_BLOCK_SIZE/4 );
				size-=VM_BLOCK_SIZE;
				Pool.ProgressUpdate( VM_BLOCK_SIZE );
			}
			if (size) {
				HistoryFile->Read( VM.buffer, size);
				VM.WriteBlock( (float*)VM.buffer, size/4 );
			}
			Pool.HideProgress();
		}
		break;
	case H_FULL:
		HistoryFile->Read(&Pool.selection,sizeof(&Pool.selection));
		HistoryFile->Read(&end,sizeof(&end));
		HistoryFile->Read(&Pool.pointer,sizeof(&Pool.pointer));
		HistoryFile->Read(&Pool.l_pointer,sizeof(&Pool.l_pointer));
		HistoryFile->Read(&Pool.r_pointer,sizeof(&Pool.r_pointer));
		HistoryFile->Read(&Pool.r_sel_pointer,sizeof(&Pool.r_sel_pointer));
		HistoryFile->Read(&Pool.sample_bits,sizeof(&Pool.sample_bits));
		HistoryFile->Read(&Pool.frequency,sizeof(&Pool.frequency));
		HistoryFile->Read(&Pool.sample_type,sizeof(&Pool.sample_type));
		HistoryFile->Read(&Pool.m_format,sizeof(&Pool.m_format));

		size = (end+1)*4*Pool.sample_type;
		Pool.size = end;

		VM.Reset();

		if (size < VM_BLOCK_SIZE){					// files smaller than 256Kb without progressBar
			HistoryFile->Read( VM.buffer, size);
			VM.WriteBlockAt( start*Pool.sample_type, (float*)VM.buffer, size/4 );
		}else{
			Pool.StartProgress(Language.get("RESTORE_UNDO"), size);
			VM.SetPointer(0);
			while(size>=VM_BLOCK_SIZE){
				HistoryFile->Read( VM.buffer, VM_BLOCK_SIZE);
				VM.WriteBlock( (float*)VM.buffer, VM_BLOCK_SIZE/4 );
				size-=VM_BLOCK_SIZE;
				Pool.ProgressUpdate( VM_BLOCK_SIZE );
			}
			if (size) {
				HistoryFile->Read( VM.buffer, size);
				VM.WriteBlock( (float*)VM.buffer, size/4 );
			}
			Pool.HideProgress();
		}
		break;
	}

	m_undo = false;
	m_redo = true;

	release_sem(histSem);
	return true;
}

/*******************************************************
*   ReDo
*******************************************************/
bool History::ReDo(){
	if (!m_undo)	return false;			// no undo data at all
	Pool.mainWindow->PostMessage(TRANSPORT_STOP);	// can not use playing here

/*
 *	@TODO: Add Redo Code
*/

	m_redo = false;
	return true;
}

/*******************************************************
*   
*******************************************************/
bool History::HasUndo(){
	return m_undo;
}

/*******************************************************
*   
*******************************************************/
bool History::HasRedo(){
	return m_redo;
}

/*******************************************************
*   
*******************************************************/
void History::Reset(){
	m_undo = false;
}
