/*******************************************************
*   Index Studio
*   
*   @author  Frans van Nispen (xlr8@tref.nl)
*   @date    29-07--2001
*
*******************************************************/

#ifndef _Index_VIEW
#define _Index_VIEW
#include <View.h>
#include <Bitmap.h>

class IndexView: public BView{
 public:
	IndexView(BRect r);
	virtual ~IndexView();
	virtual void AttachedToWindow();
	virtual void Draw(BRect);
	virtual void MouseDown(BPoint);
	virtual void MouseUp(BPoint);
	virtual void MouseMoved(BPoint, uint32, const BMessage *);
	virtual void MessageReceived(BMessage *msg);
	virtual void FrameResized(float width, float height);

 private:
	bool CalculateCache(BRect);
 	BBitmap *OffScreen;

	float		*index_memory_left;				// zoom-view memory
	float		*index_memory_right;			// zoom-view memory

	bool drag, select, m_resized;
	BRect cache;
	BPoint old;
	int64 t, t2;
	float old_x;

	sem_id indexSem;
};

#endif


