/*************************************************
* OpenPanel that enables to browse files and play them
*
****************************************************/
#ifndef _SNDFILEPANEL_H_
#define _SNDFILEPANEL_H_

#include <Button.h>
#include <Handler.h>
#include <FileGameSound.h>
#include <FilePanel.h>
#include <MessageRunner.h>
#include <StringView.h>
#include <String.h>
#include <File.h>
#include <NodeInfo.h>

class OpenPanel : public BFilePanel, public BHandler {
public:
	OpenPanel(BHandler* handler);
	virtual ~OpenPanel(void);
	
	virtual void SelectionChanged(void);
	virtual void WasHidden(void);
	
	virtual void MessageReceived(BMessage* msg);

private:
	BFileGameSound* mSndFile;
	BButton* mPlayBtn;
	BStringView *line1, *line2;
	// use a BMessageRunner to periodically remind us
	// to check whether mSndFile has stopped playing so
	// we can reset mPlayBtn's label to "Play".
	BMessageRunner* mBtnUpdater;
};

class OpenFilter : public BRefFilter {
public:
	OpenFilter(void);
	virtual ~OpenFilter(void);
	
	virtual bool Filter(const entry_ref* ref,BNode* node,
		struct stat* st,const char* filetype);
};

#endif // #ifndef _SNDFILEPANEL_H_