#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "Analyzers.h"
#include "BitmapDrawer.h"
#include "main.h"

#define NUM_BANDS		32

class PlasmaView : public BView{
  public:
	PlasmaView(BRect);
	~PlasmaView();
	virtual void Draw(BRect);
	virtual void Pulse();
	float Data[3][NUM_BANDS];
  private:
	BBitmap *bitmap;
};


PlasmaView::PlasmaView(BRect r) : BView(r, NULL, B_FOLLOW_ALL, B_WILL_DRAW | B_PULSE_NEEDED)
{
	SetViewColor(B_TRANSPARENT_COLOR);
	for (int i=0; i<32; i++){
		Data[0][i] = 0;		// clear buffer
		Data[1][i] = 0;		// clear buffer
		Data[2][i] = 0;		// clear buffer
	}
	bitmap = new BBitmap(Bounds(), B_RGB32);
}


PlasmaView::~PlasmaView()
{
	delete bitmap;
}

void PlasmaView::Draw(BRect r)
{
	rgb_color col[] = { (rgb_color){ 255,0,0 },
 						(rgb_color){ 255,31,0 },
 						(rgb_color){ 255,63,0 },
 						(rgb_color){ 255,95,0 },
 						(rgb_color){ 255,127,0 },
 						(rgb_color){ 255,159,0 },
 						(rgb_color){ 255,191,0 },
 						(rgb_color){ 255,255,0 },

 						(rgb_color){ 191,255,0 },
 						(rgb_color){ 159,255,0 },
 						(rgb_color){ 127,255,0 },
 						(rgb_color){ 95,255,0 },
 						(rgb_color){ 63,255,0 },
 						(rgb_color){ 31,255,0 },
 						(rgb_color){ 0,255,0 },
 						(rgb_color){ 0,255,31 },

 						(rgb_color){ 0,255,63 },
 						(rgb_color){ 0,255,95 },
 						(rgb_color){ 0,255,127 },
 						(rgb_color){ 0,255,159 },
 						(rgb_color){ 0,255,191 },
 						(rgb_color){ 0,255,255 },
 						(rgb_color){ 0,191,255 },
 						(rgb_color){ 0,159,255 },

 						(rgb_color){ 0,127,255 },
 						(rgb_color){ 0,95,255 },
 						(rgb_color){ 0,63,255 },
 						(rgb_color){ 0,31,255 },
 						(rgb_color){ 0,0,255 },
 						(rgb_color){ 31,0,255 },
 						(rgb_color){ 63,0,255 },
 						(rgb_color){ 95,0,255 },
 						(rgb_color){ 127,0,255 },
 						(rgb_color){ 159,0,255 },
 						(rgb_color){ 191,0,255 },
 						(rgb_color){ 255,0,255 },
 						};
	float x, y;
	r = Bounds();
	BitmapDrawer drawer(bitmap);

	float cx = r.Width()/2;
	float cy = r.Height()/2;
	float d = sqrt(cx*cx+cy*cy);

	for (int i=0; i<NUM_BANDS; i++){
		x = r.Width() * Data[0][i] * 2 - r.Width();
		y = r.Height()/2 + r.Height() * Data[1][i];
		drawer.PlotRGB(x,y,col[i]);

		if (Data[0][i] > Data[1][i])
		{
			Data[2][i] = 1;		// delay
			Data[1][i] = Data[0][i];
		}

		Data[0][i] -= 0.05;
		if (Data[0][i] <0)
			Data[0][i] = 0;
	}
	
	DrawBitmapAsync( bitmap, r, r );
}

void PlasmaView::Pulse()
{
	for (int32 i=0; i<NUM_BANDS; i++){
		if ( Data[2][i] >0 )
			Data[2][i] -= 0.1;
		else
		{
			Data[1][i] -= 0.01;
			if (Data[1][i] <0)
				Data[1][i] = 0;
		}
	}
	Draw(Bounds());
}

/*******************************************************
*   
*******************************************************/
PlasmaWindow::PlasmaWindow() : AnalyzeWindow(BRect(50,350,270, 500),Language.get("PLASMA_SCOPE"))
{
	AddChild(view = new PlasmaView(Bounds()));
}

/*******************************************************
*   
*******************************************************/
void PlasmaWindow::PlayBuffer(float *buffer, size_t size)
{
	int c, i;
	float y;
	int xscale[] = 	{ 2,   3,   4,   5,   6,   7,   8,   9,
				     10,  12,  14,  18,  22,  26,  32,  38,
				     44,  48,  52,  56,  60,  67,  74,  81,
				     88, 110, 132, 154, 176, 202, 228, 254 };
	
	for (size_t j=0; j<size; j+=NUM_BANDS*512){
		for(i = 0; i < NUM_BANDS; i++)
		{
			for(c = 0, y = 0; c < 256; c+=xscale[i])
			{
				y += buffer[j*512+c*2];
			}
			y /= ceil(256/(float)xscale[i]);
			if(y > ((PlasmaView*)view)->Data[0][NUM_BANDS-i-1])
				((PlasmaView*)view)->Data[0][NUM_BANDS-i-1] = y;
		}
	}
}
