#include <InterfaceKit.h>
#include <StorageKit.h>
#include <String.h>
#include <Path.h>
#include <TranslationKit.h>
#include <TranslationUtils.h>
#include <stdio.h>

#include "Globals.h"
#include "PrefDirs.h"
#include "SpinControl.h"

#define SET_TEMP					'stTP'
#define SET_VST						'stVT'

/*******************************************************
*   Setup the main view. Add in all the niffty components
*   we have made and get things rolling
*******************************************************/
PrefDirs::PrefDirs(BRect frame):BView(frame, "Prefs general", B_FOLLOW_ALL, 0){
	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	
	BRect r = frame;
//	r.right /=2;
	r.top = 5;	r.bottom = 25;
	r.right *= .98;
	AddChild(temp_file = new BTextControl(r, NULL, Language.get("TEMP_DIR"), Prefs.temp_dir.String(), new BMessage(SET_TEMP) ));
	r.OffsetBy(0,28);
	AddChild(vst_path = new BTextControl(r, NULL, Language.get("VST_DIR"), Prefs.vst_dir.String(), new BMessage(SET_VST) ));
	
	float w = r.Width() * 0.4;
	temp_file->SetDivider(w);
	vst_path->SetDivider(w);
}

/*******************************************************
*  
*******************************************************/
PrefDirs::~PrefDirs()
{
}

/*******************************************************
*  
*******************************************************/
void PrefDirs::AttachedToWindow(){
	temp_file->SetTarget(this);
	vst_path->SetTarget(this);
}

/*******************************************************
*
*******************************************************/
void PrefDirs::MessageReceived(BMessage *msg)
{
	switch(msg->what){
	case SET_TEMP:
		Prefs.temp_dir.SetTo(temp_file->Text());
		(new BAlert(NULL,Language.get("TEMP_CHANGED"),Language.get("OK")))->Go();
		break;

	case SET_VST:
		Prefs.vst_dir.SetTo(vst_path->Text());
		break;

	default:
		BView::MessageReceived(msg);
		break;   
	}
}
