/*******************************************************
*   SampleStudio©
*   
*   This file may be used under under the license as
*   stated below. For more information about License
*   types see the included LICENSE file. If you did 
*   not recive a copy of that file contact the author.
*   
*   @author  Frans van Nispen (frans@xentronix.com)
*   @date    Mar 14 2002
*******************************************************/

#include <Application.h>
#include <InterfaceKit.h>
#include <stdio.h>
#include <stdlib.h>

#include "Globals.h"
#include "ProgressWindow.h"

ProgressWindow::ProgressWindow(BRect frame)
	:BWindow(frame, "Progress" ,B_FLOATING_WINDOW_LOOK,B_MODAL_APP_WINDOW_FEEL,B_NOT_RESIZABLE | B_NOT_CLOSABLE | B_NOT_ZOOMABLE)
{
	Lock();
	Looper()->SetName("Progress Window");
	
	BView *view = new BView(frame, NULL, B_FOLLOW_ALL, B_WILL_DRAW | B_NOT_CLOSABLE);
	frame.InsetBy(2,2);
	frame.top -= 8;
	view->AddChild(bar = new BStatusBar(frame, NULL, NULL, NULL));
	view->SetViewColor(216,216,216);
	AddChild(view);
	
	Unlock();
	Run();
}

ProgressWindow::~ProgressWindow()
{
}

void ProgressWindow::MessageReceived(BMessage *message)
{
	switch (message->what){
	default:
		BWindow::MessageReceived(message);
	}
}

void ProgressWindow::StartProgress(const char *label, int32 max)
{
	SetTitle(Language.get(label));
	bar->Reset();
	bar->SetMaxValue(max);

	ResizeTo(300,30);
	MoveTo( Prefs.frame.Width()/2 -150 + Prefs.frame.left, 	Prefs.frame.Height()/2 -15 + Prefs.frame.top);
	if (IsHidden())
		Show();
}


void ProgressWindow::SetProgress(int32 p)
{
	bar->Update(p);
}

