#ifndef REALTIME_FILTER_WINDOW_H
#define REALTIME_FILTER_WINDOW_H

#include <Application.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include <String.h>
#include "SpinControl.h"
#include "SpinSlider.h"

#define FILTER_MIN_WIDTH	240

// if a contro has this message, it will be patched to UpdateValues()
#define CONTROL_CHANGED	'chgd'

class RealtimeFilter : public BWindow {
  public:
	RealtimeFilter(const char *name, bool realtime = true);
	virtual void MessageReceived(BMessage*);
	virtual bool QuitRequested();

	// init the filters, allocate the required data, ....	
	// total_samples is only needed in filters like fade
	// The pass is needed for multi-pass filters that also need analyzing
	// like the normalize filter
	virtual bool InitFilter(float frequency, int32 channels = 2, int32 pass = 0, int32 total_samples = 0);
	
	// start the realtime buffers and stop them again
	// no need to overload, just for internal use
	void Start();
	void Stop();

	// need to release memory here as the play-routines need
	// to be stopped before this is possible
	virtual void DeAllocate();
	
	// The actual data to analyze !
	virtual void FilterBuffer(float *, size_t) = 0;
	
	// Update values, called on a CONTROL_CHANGED message
	virtual void UpdateValues();

	// the configView
	virtual BView* ConfigView();
	
	// multipass stuff
	int32 Passes();
	void SetPasses(int32 x);

  private:
	static void _FilterBuffer(float *, size_t, void *);
	bool play_self, loop;
	int32 m_id;
	int32 m_passes;
  protected:
	float m_frequency;
	int32 m_channels, m_pass, m_total;
	BView *parent;
	BCheckBox *box;
};

#endif