#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "Analyzers.h"
#include "main.h"

#define WIDTH		256

class SampleScopeView : public BView{
  public:
	SampleScopeView(BRect);
	~SampleScopeView();
	virtual void Draw(BRect);
	virtual void Pulse();
	float Data[2][WIDTH];
};


SampleScopeView::SampleScopeView(BRect r) : BView(r, NULL, B_FOLLOW_ALL, B_WILL_DRAW | B_PULSE_NEEDED)
{
	SetViewColor(0,0,0);
	for (int i=0; i<WIDTH; i++){
		Data[0][i] = 0;		// clear buffer
		Data[1][i] = 0;		// clear buffer
	}
}


SampleScopeView::~SampleScopeView()
{
}

void SampleScopeView::Pulse()
{
	Invalidate();
}

void SampleScopeView::Draw(BRect r)
{
	r = Bounds();
	SetHighColor(0,0,0);
	FillRect(r);

	r.bottom /= 2;		// half
	float m = (r.top + r.bottom)/2;
	float a = r.Height()/2;
	
	SetHighColor( 160,0,0 );
	StrokeLine( BPoint(0,m), BPoint(r.right,m) );
	SetHighColor( 255,80,0 );
	MovePenTo( BPoint(0, m-Data[0][0]*a) );
	for (int i=0; i<WIDTH; i++){
		StrokeLine( BPoint( i*r.Width()/WIDTH, m-Data[0][i]*a) );
		Data[0][i] = 0;
	}

	m += r.Height();
	SetHighColor( 0,0,160 );
	StrokeLine( BPoint(0,m), BPoint(r.right,m) );
	SetHighColor( 0,80,255 );
	MovePenTo( BPoint(0, m-Data[1][0]*a) );
	for (int i=0; i<WIDTH; i++){
		StrokeLine( BPoint( i*r.Width()/WIDTH, m-Data[1][i]*a) );
		Data[1][i] = 0;
	}
}

/*******************************************************
*   
*******************************************************/
SampleScopeWindow::SampleScopeWindow() : AnalyzeWindow(BRect(50, 50, 270, 150),Language.get("SAMPLE_SCOPE"))
{
	AddChild(view = new SampleScopeView(Bounds()));
}

/*******************************************************
*   
*******************************************************/
void SampleScopeWindow::PlayBuffer(float *buffer, size_t size)
{
	for (size_t i=0; i<WIDTH; i++){
		((SampleScopeView*)view)->Data[0][i] = *buffer++;
		((SampleScopeView*)view)->Data[1][i] = *buffer++;
	}
}
