#ifndef SAVEPANEL_H
#define SAVEPANEL_H

#include <storage/FilePanel.h>
#include <InterfaceKit.h>
#include <MediaKit.h>

#define PANEL_FORMAT 	 'sfpf'
#define PANEL_CODEC		 'sfps'
#define SAVE_AUDIO		'sveA'

// ------------------- FileFormatMenuItem -------------------

class FileFormatMenuItem : public BMenuItem
{
public:
				FileFormatMenuItem(media_file_format *format);
	virtual		~FileFormatMenuItem();
	
	media_file_format fFileFormat;
};

// ------------------- CodecMenuItem -------------------

class CodecMenuItem : public BMenuItem
{
public:
				CodecMenuItem(media_codec_info *ci, uint32 msg_type);
	virtual		~CodecMenuItem();
	
	media_codec_info fCodecInfo;
};

// ------------------- Save Panel -------------------

class SavePanel : public BFilePanel, public BHandler {
  public:
	SavePanel(BHandler *handler);
	void MessageReceived(BMessage *message);
	~SavePanel();
	void GetSelectedFormatInfo(media_file_format **format, media_codec_info **audio);
	void SetFormatInfo(media_file_format *format, media_codec_info *audio);

  private:
	void BuildFormatMenu();
	void BuildAudioMenu();

	BMenuField	*fFormatMenu;
	BMenuField	*fAudioMenu;
};

#endif
