/*******************************************************
*   Inferno©
*   
*   This file may be used under the license as
*   stated below. For more information about License
*   types see the included LICENSE file. If you did 
*   not recive a copy of that file contact the author.
*   
*   @author  Frans van Nispen (xlr8@tref.nl)
*   @version beta
*   @date    Feb 5 2000
*   @license Inferno SDK Code
*
*	v1.01	Added: SetClicks()	This sets the number of
*			clicks needed for a ColorWindow to appear.
*******************************************************/
#ifndef I_SWATCH_VIEW_H
#define I_SWATCH_VIEW_H

#include <Window.h>
#include <Control.h>
#include <Bitmap.h>

class SwatchView : public BControl
{
 public:
 	SwatchView(BRect frame, const char *name, BMessage* msg = NULL);
	SwatchView(BRect frame, const char *name, rgb_color color, BMessage* msg = NULL);
	virtual ~SwatchView();
	
	virtual	void Draw(BRect update_rect);
	virtual void MouseDown(BPoint point);
	
	virtual void SetEnabled(bool enabled);

	virtual void MessageReceived(BMessage* msg);
	virtual void AttachedToWindow();
	virtual void DetachedFromWindow();

	virtual void SetColor(const rgb_color &color);
	rgb_color Color(void) const;

	void SetActive(bool c);

 protected:
 	virtual void DrawOffscreen();
	
 private:
	virtual void Init(void);
	BBitmap* make_bitmap(void);	
	bool active;

	const char *m_name;
 	BView* m_view;
 	BBitmap* m_bitmap;
	rgb_color m_color;
};

#endif
