/*******************************************************
*   TimeBar Studio
*
*   @author  Frans van Nispen (xlr8@tref.nl)
*   @date    29-07--2001
*
*******************************************************/

#include <TranslationKit.h>
#include <Bitmap.h>
#include <stdio.h>

#include "TimeBarView.h"
#include "MainWindow.h"
#include "Globals.h"

TimeBarView::TimeBarView(BRect r) : 
	BView(r, "TimeBar view", B_FOLLOW_BOTTOM | B_FOLLOW_LEFT_RIGHT, B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE)
{
	SetViewColor(B_TRANSPARENT_COLOR);
}

//*****************************************************
TimeBarView::~TimeBarView()
{
}

//*****************************************************
void TimeBarView::AttachedToWindow()
{
}

//*****************************************************
void TimeBarView::Draw(BRect rect)
{
	BRect r = Bounds();
	char s[255];

	SetLowColor(Prefs.time_back_color);
	FillRect(r, B_SOLID_LOW);
	
	if (Pool.size == 0)	return;
	
	SetHighColor(64,64,64);
	StrokeLine(BPoint(r.left, r.top), BPoint(r.right, r.top));

	if (Pool.sample_type == NONE)	return;

	int32 w = r.IntegerWidth();
	int32 x = (int32)r.left;
	float b;

	BFont font;
	GetFont(&font);
	font_height fh;
	font.GetHeight(&fh);
	
	float fw = font.StringWidth(" 00:00.000 ");
//	float t = floor( Pool.l_pointer/Pool.frequency);
	float t = ( Pool.l_pointer/Pool.frequency);
	float t_add = (Pool.r_pointer - Pool.l_pointer)/(Pool.frequency*w);
	float t_marge = t_add * fw;
	float t_small_marge = t_marge/5.0f;
	float t_small_bound = t + t_small_marge;
	float t_bound = t + t_marge;

	while (w>0){
		t += t_add;

		if (t >= t_bound){
			int time = (int)((t-(int)t)*1000);
			int sec = (int)fmod(t,60);
			int min = ((int)t)/60;
			sprintf(s, "%d:%.2d.%.3d", min, sec, time);
			t_bound += t_marge;
			b = r.top + 5;
			SetHighColor(Prefs.time_text_color);
			DrawString(s, BPoint(x - font.StringWidth(s)/2.0f, r.bottom));
			SetHighColor(Prefs.time_marks_color);
			StrokeLine( BPoint( x, r.top+1 ), BPoint( x, b) );
		}else if (t >= t_small_bound){
			t_small_bound += t_small_marge;
			SetHighColor(Prefs.time_small_marks_color);
			b = r.top + 1;
			StrokeLine( BPoint( x, r.top+1 ), BPoint( x, b) );
		}
		x ++;
		w --;
	}

}
