/*******************************************************
*   SampleStudio©
*   
*   This file may be used under under the license as
*   stated below. For more information about License
*   types see the included LICENSE file. If you did 
*   not recive a copy of that file contact the author.
*   
*   @author  Frans van Nispen (frans@xentronix.com)
*   @date    Mar 14 2002
*******************************************************/

#include <Window.h>

#include <stdio.h>

#include "Globals.h"
#include "ToolTipWindow.h"


/*******************************************************
*   Our wonderful BWindow, ya its kewl like that.
*   we dont do much here but set up the menubar and 
*   let the view take over.  We also nead some message
*   redirection and handling
*******************************************************/
ToolTipWindow::ToolTipWindow() : BWindow(BRect(0,0,100,19),"Tool Tip",
      B_NO_BORDER_WINDOW_LOOK,
      B_FLOATING_ALL_WINDOW_FEEL,
      B_ASYNCHRONOUS_CONTROLS|B_NOT_RESIZABLE|B_AVOID_FRONT|B_AVOID_FOCUS){
   
   Looper()->SetName(TOOL_TIP_WINDOW);
   
   BView *v = new BView(Bounds(),"",B_FOLLOW_ALL,0);
   v->SetViewColor(255,255,120);
   AddChild(v);
   
   BRect b = v->Bounds();
   b.Set(b.left-1,b.top-1,b.right+1,b.bottom+1);
   BBox *bb = new BBox(b,"",B_FOLLOW_ALL);
   v->AddChild(bb);
   
   b = bb->Frame();
   b.InsetBy(1,1);
   b.left = 4;
   b.bottom --;
   tipv = new BStringView(b,"","...",B_FOLLOW_ALL);
   tipv->SetAlignment(B_ALIGN_CENTER);
   bb->AddChild(tipv);
   
   Run();
}

/*******************************************************
*   
*******************************************************/
void ToolTipWindow::Tip(BPoint p,const char *tipname){
   if(Lock()){
      tipv->SetText(tipname);
      int32 W = (int32)ceil(tipv->StringWidth(tipname));
      ResizeTo(W+16,be_plain_font->Size() + 8);
      p.x += 16;
      p.y += 16;
      MoveTo(p);
      while(IsHidden()){ Show(); }
      Unlock();
   }
}

/*******************************************************
*   
*******************************************************/
void ToolTipWindow::Bye(){
   Lock();
   while(!IsHidden()){ Hide(); }
   Unlock();
}

/*******************************************************
*   
*******************************************************/
void ToolTipWindow::MessageReceived(BMessage* msg){
  
   switch(msg->what){

   default:
      BWindow::MessageReceived(msg);
   }
}

/*******************************************************
*   
*******************************************************/
bool ToolTipWindow::QuitRequested(){
   return true;
}
