#ifndef _VM_FILE_H
#define _VM_FILE_H
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#define CACHE_SIZE	1024*64
#define CACHE_HALF	CACHE_SIZE/2
#define CACHE_THRES	CACHE_SIZE/4
#define VM_BLOCK_SIZE	256*1024

class VMSystem {
  public:
	VMSystem();
	~VMSystem();
	
	// chache size in bytes
	void Init();

	// cursor management
	void SetPointer(int64 p);		// Set the current pointer
	int64 Pointer();				// Get pointer

	// manage play cache
	void	SetPlayPointer(int64 p);// Set the current play pointer and initiase cache
	int64	PlayPointer();				// Get play pointer
	void	ReadCache(float*, size_t size);
	void	StopCache();

	// read/write data
	float	Read();					// read a sample
	void	Write(float);			// write sample
	float	ReadAt(int64);			// read a sample
	void	WriteAt(int64,float);	// write sample
	
	// read/write memory blocks, size in samples
	void	ReadBlock(float*, size_t size);
	void	WriteBlock(float*, size_t size);
	void	ReadBlockAt(int64, float*, size_t size);
	void	WriteBlockAt(int64, float*, size_t size);

	void	Reset();				// delete file and create a new one, flush
	
	// insert space. This does NOT clear the area !
	void	Insert(int64, size_t size);
	// insert space. This does clear the area
	void	InsertClean(int64, size_t size);
	// remove space
	void	Remove(int64, size_t size);
	void	SetSize(off_t size);

	// buffer for others to use to load and save to
	void	*buffer;

  private:
	static	int32 Thread2_(void *data){ return ((VMSystem*)(data))->FillCache();  }
	int32	FillCache();
	thread_id myThread;
	bool	m_lock_read;
	int32	m_nReadCachePos;

	int64	m_lPlayPointer;		// current playback cache
	int64	m_lCachePointer;		// current cache position
	float	*fCache;			// cache buffer

	BFile *CacheFile;				//  the file to contain the cache
	entry_ref file_ref;

  	int64	m_lCurrentPointer;		// pointer in samples
	sem_id	m_semVM;
};

extern VMSystem VM; // Included so you don't have too 
#endif
