/*

	VSTFilter.h
	by Andrea Anzani

	Original code by Georges-Edouard Berenger
	
*/

#ifndef _VSTFILTER_H_
#define _VSTFILTER_H_

#ifndef __audioeffectx__
	#include "audioeffectx.h"
#endif


#include <Locker.h>
#include "string.h"
#include "KernelKit.h"
#include "String.h"
#include "Entry.h"

class BListView;
class VSTFilterPlugin;
class BList;

#ifdef VSTMIDI
	class MIDI_consumer;
#endif

typedef	struct PlugInEntry {

		BString		name;
		entry_ref	ref;
};

typedef struct {
	AEffect	*			effect;
	VSTFilterPlugin *	plugin;
} effectPluginPair;

class VSTFilterPlugin  //  : public FilterPlugin
{
public:
						VSTFilterPlugin (const char*);
		virtual 			~VSTFilterPlugin ();

	
	status_t			InitCheck () { return fImage > 0 ? B_OK : B_ERROR; }
		
	virtual status_t	FilterFloat (float **input, float **output, int32 framecount, void *info);
	virtual BView *		Configure ();
	virtual void		SetConfig (BMessage *config);
	virtual void		GetConfig (BMessage *config);
	
	bool		active;
	void		SetStatus(bool b){
	 
	 active=b; 
	 if(b)
	 fEffect->dispatcher (fEffect, effMainsChanged, 0, 1, 0, 0.);	// turn on
		else
	 fEffect->dispatcher (fEffect, effMainsChanged, 0, 0, 0, 0.);	// turn on
				
	 };
	bool		GetStatus() {return active;}
	
	// The VST plugin makes request to the host by calling the "audioMaster" call.
	// It might want to transmit the request to one the following methods.
	long				NeedIdle ();
	void				IdleLoop ();
	long				WantMidi ();

	// "audiomaster" callback needs to identify an AEffect. Hence this register
	static void				Register (VSTFilterPlugin * factory, AEffect * effect);
	static void				Unregister (AEffect * effect);
	static VSTFilterPlugin *	Identify (AEffect * effect);
		
	static void load_plug_ins (const char *path, BList*);
private: // global data members for the register
	
	static effectPluginPair *	fPairs;
	static int			fPairsCount;
	static BLocker		fLock;
	
public:
	
	void					SetMidiProducer (int32 id);
	const char *			GetMidiProducerName ();
	int32				GetSampleRate () { return fSampleRate; }
	int32				GetBlockSize () { return fBlockSize; }
	uint32				GetLastFilterTime () { return fLastFilter; }
	
	// Grant public access to these for simplicity
	//VSTPluginFactory *	fFactory;
	AEffect *			fEffect;
	BString				name;
	BString				filename;
	
	void setBPM(int);
	
private:
	int32				fSampleRate;
	int32				fBlockSize;
	uint32				fLastFilter;
	#ifdef VSTMIDI
		MIDI_consumer *		fMidiConsumer;
		BString				fMidiPortName;
	#endif
	image_id			fImage;
	thread_id			fIdleThread;
	sem_id				fIdleSem;
	
};

// VST plugins can make requests to the host through this call
long audioMaster (AEffect *eff, long opcode, long index, long value, void *ptr, float opt);

void certify_effect (AEffect * effect);

#define VST_INSTRUMENTS 0
#define VST_INSTRUMENTS_MAX_OUTPUT 16

#endif // _VSTFILTER_H_
