#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "RealtimeFilter.h"
#include "VSTPlugin.h"
#include "VSTSoundConfigure.h"

#define	 FRAMES_NUM		1024
#define	 FRAMESIZE		8

/*******************************************************
*   
*******************************************************/
VSTPlugin::VSTPlugin(VSTFilterPlugin* p) : RealtimeFilter(Language.get("VST")), plugin(p)
{
	SetTitle(p->name.String());
}

/*******************************************************
*   
*******************************************************/
BView *VSTPlugin::ConfigView()
{
	return plugin->Configure();
}

/*******************************************************
*   Init & exit
*******************************************************/
bool VSTPlugin::InitFilter(float f, int32 c, int32 pass, int32 size)
{
	RealtimeFilter::InitFilter(f, c, pass, size);

	stream[0] = new float[BUFFER_SIZE/2];
	stream[1] = new float[BUFFER_SIZE/2];

	return true;
}

void VSTPlugin::DeAllocate()
{
}

/*******************************************************
*   
*******************************************************/
void VSTPlugin::FilterBuffer(float *buffer, size_t size)
{
	// create in buffer
	float *inL = stream[0];
	float *inR = stream[1];
	float *p = buffer;
	for (size_t i=0; i<size/2; i++) {
		*inL++ = *p++;
		*inR++ = *p++;
	}

	plugin->FilterFloat(stream,stream, size/2,NULL);

	// copy back
	inL = stream[0];
	inR = stream[1];
	for (size_t i=0; i<size/2; i++) {
		*buffer++ = *inL++;
		*buffer++ = *inR++;
	}
}
