/*******************************************************
*   Sample Studio
*
*	Draws a VU meter to represent the input volume
*   
*   @author  Frans van Nispen (xlr8@tref.nl)
*   @date    29-07--2001
*
*******************************************************/

#include <TranslationKit.h>
#include <Bitmap.h>

#include "VUView.h"
#include "Globals.h"

extern cookie_record play_cookie;

VUView::VUView(BRect r) : 
	BView(r, "VU view", B_FOLLOW_BOTTOM, B_WILL_DRAW | B_PULSE_NEEDED)
{
	SetViewColor(B_TRANSPARENT_COLOR);
	LedsActive = BTranslationUtils::GetBitmapFile("./Bitmaps/LedsActive.png");
	LedsInactive = BTranslationUtils::GetBitmapFile("./Bitmaps/LedsInactive.png");
}

//*****************************************************
VUView::~VUView()
{
	delete LedsActive;
	delete LedsInactive;
}

//*****************************************************
void VUView::AttachedToWindow()
{
	SetViewBitmap(BTranslationUtils::GetBitmapFile("./Bitmaps/VU.png"), B_FOLLOW_ALL);
}

//*****************************************************
void VUView::Pulse()
{
	left_max -= 0.04;	if (left_max<0.0)	left_max = 0.0;
	right_max -= 0.04;	if (right_max<0.0)	right_max = 0.0;

	if (!Pool.IsPlaying()){
		play_cookie.left = play_cookie.right = 0.0;
	}else{
		left_max = MAX(left_max, play_cookie.left);
		right_max = MAX(right_max, play_cookie.right);
	}
	Invalidate(BRect(9,8,23,56));
}

//*****************************************************
void VUView::Draw(BRect rect)
{
	float left = 56.0f - play_cookie.left * 48.0f;
	float right = 56.0f - play_cookie.right * 48.0f;
	DrawBitmapAsync(LedsActive, BRect(0, left-8, 6, 48), BRect(9, left, 15, 56));
	DrawBitmapAsync(LedsActive, BRect(0, right-8, 6, 48), BRect(17, right, 23, 56));

	left = 56.0f - left_max * 48.0f;
	right = 56.0f - right_max * 48.0f;
	DrawBitmapAsync(LedsActive, BRect(0, left-8, 6, left-8), BRect(9, left, 15, left));
	DrawBitmapAsync(LedsActive, BRect(0, right-8, 6, right-8), BRect(17, right, 23, right));
}
