#include	<stdio.h>
// #include	<conio.h>

#include "NoWindows.h"

#include	"sound_iocs.h"
#include	"x68sound.h"

// 16bitͤΥХȤ¤Ӥդˤ֤
#if 0
unsigned short bswapw(unsigned short data) {
#ifdef ENABLE_I386_ASM
	__asm {
		mov ax,data
		ror ax,8
	}
#else
	data = ((data >> 8) & 0xFF) | ((data << 8) & 0xFF00);
	return data;
#endif
}

// 32bitͤΥХȤ¤Ӥդˤ֤
void *bswapl(void *adrs) {
#ifdef ENABLE_I386_ASM
	__asm {
		mov	eax,adrs
		bswap	eax
	}
#else
	unsigned char t;
	unsigned char *a;
	a = (unsigned char *)adrs;
	t = a[0];
	a[0] = a[3];
	a[3] = t;
	t = a[1];
	a[1] = a[2];
	a[2] = t;
	return adrs;
#endif
}
#endif

volatile unsigned char AdpcmStat=0; // $02:adpcmout $12:adpcmaot $22:adpcmlot $32:adpcmcot
volatile unsigned char OpmReg1B=0;  // OPM 쥸 $1B 
volatile unsigned char DmaErrCode = 0;

volatile unsigned char *Adpcmcot_adrs;
volatile int	Adpcmcot_len;

// OPMBUSYԤ
void OpmWait() {
	while (X68Sound_OpmPeek() & 0x80);
}

// IOCS _OPMSET ($68) ν
// []
//   int addr : OPM쥸ʥС(0255)
//   int data : ǡ(0255)
void _iocs_opmset(int addr, int data) {
	if (addr == 0x1B) {
		OpmReg1B = (OpmReg1B&0xC0)|(data&0x3F);
		data = OpmReg1B;
	}
	OpmWait();
	X68Sound_OpmReg(addr);
	OpmWait();
	X68Sound_OpmPoke(data);
}

// IOCS _OPMSNS ($69) ν
// []
//   bit 0 : ޡAСեΤȤ1ˤʤ
//   bit 1 : ޡBСեΤȤ1ˤʤ
//   bit 7 : 0ʤХǡ񤭹߲ǽ

int _iocs_opmsns() {
	return X68Sound_OpmPeek();
}

void (CALLBACK *OpmIntProc)()=NULL;		// OPMΥޡ߽ɥ쥹

// IOCS _OPMINTST ($6A) ν
// []
//   void *addr : ߽ɥ쥹
//                0ΤȤϳ߶ػ
// []
//   ߤꤵ줿 0
//   ˳ߤꤵƤϤγ߽ɥ쥹֤
int _iocs_opmintst(void *addr) {
	if (addr == 0) {				// 0λϳߤػߤ
		OpmIntProc = NULL;
		X68Sound_OpmInt(OpmIntProc);
		return 0;
	}
	if (OpmIntProc != NULL) {		// ꤵƤϡνɥ쥹֤
		return (int)OpmIntProc;
	}
	OpmIntProc = (void (CALLBACK *)())addr;
//	OpmIntProc = void (CALLBACK *addr)(void);
	X68Sound_OpmInt(OpmIntProc);	// OPMγ߽ɥ쥹
	return 0;
}

// DMAžλ߽롼
void CALLBACK DmaIntProc() {
	if (AdpcmStat == 0x32 && (X68Sound_DmaPeek(0x00)&0x40)!=0) {	// ƥ˥塼⡼ɻν
		X68Sound_DmaPoke(0x00, 0x40);	// BTCӥåȤ򥯥ꥢ
		if (Adpcmcot_len > 0) {
			int dmalen;
			dmalen = Adpcmcot_len;
			if (dmalen > 0xFF00) {	// 1٤žǤХȿ0xFF00
				dmalen = 0xFF00;
			}
			X68Sound_DmaPokeL(0x1C, Adpcmcot_adrs);	// BAR˼DMAžɥ쥹򥻥å
			X68Sound_DmaPokeW(0x1A, dmalen);	// BTC˼DMAžХȿ򥻥å
			Adpcmcot_adrs += dmalen;
			Adpcmcot_len -= dmalen;

			X68Sound_DmaPoke(0x07, 0x48);	// ƥ˥塼ڥ졼
		}
		return;
	}
	if (!(AdpcmStat&0x80)) {
		X68Sound_PpiCtrl(0x01);	// ADPCMOFF
		X68Sound_PpiCtrl(0x03);	// ADPCMOFF
		X68Sound_AdpcmPoke(0x01);	// ADPCMư
	}
	AdpcmStat = 0;
	X68Sound_DmaPoke(0x00, 0xFF);	// DMA CSR ӥåȤ򥯥ꥢ
}

// DMA顼߽롼
void CALLBACK DmaErrIntProc() {
	DmaErrCode = X68Sound_DmaPeek(0x01);	// 顼ɤ DmaErrCode ¸

	X68Sound_PpiCtrl(0x01);	// ADPCMOFF
	X68Sound_PpiCtrl(0x03);	// ADPCMOFF
	X68Sound_AdpcmPoke(0x01);	// ADPCMư

	AdpcmStat = 0;
	X68Sound_DmaPoke(0x00, 0xFF);	// DMA CSR ӥåȤ򥯥ꥢ
}

unsigned char	PANTBL[4] = {3, 1, 2, 0};

// ץ󥰼ȿPANꤷDMAž򳫻Ϥ롼
// []
//   unsigned short mode : ץ󥰼ȿ*256+PAN
//   unsigned char ccr : DMA CCR ˽񤭹ǡ
void SetAdpcmMode(unsigned short mode, unsigned char ccr) {
	if (mode >= 0x0200) {
		mode -= 0x0200;
		OpmReg1B &= 0x7F;	// ADPCMΥå8MHz
	} else {
		OpmReg1B |= 0x80;	// ADPCMΥå4MHz
	}
	OpmWait();
	X68Sound_OpmReg(0x1B);
	OpmWait();
	X68Sound_OpmPoke(OpmReg1B);	// ADPCMΥå(8or4MHz)
	unsigned char ppireg;
	ppireg = ((mode>>6)&0x0C) | PANTBL[mode&3];
	ppireg |= (X68Sound_PpiPeek()&0xF0);
	X68Sound_DmaPoke(0x07, ccr);	// DMAž
	X68Sound_PpiPoke(ppireg);	// ץ󥰥졼ȡPANPPI
}

// _iocs_adpcmoutΥᥤ롼
// []
//   unsigned char stat : ADPCMߤ³DMAžԤ$80
//                        DMAžλADPCMߤ$00
//   unsigned short len : DMAžХȿ
//   unsigned char *adrs : DMAžɥ쥹
void AdpcmoutMain(unsigned char stat, unsigned short mode, unsigned short len, unsigned char *adrs) {
	while (AdpcmStat);	// DMAžλԤ
	AdpcmStat = stat+2;
	X68Sound_DmaPoke(0x05, 0x32);	// DMA OCR ưʤ

	X68Sound_DmaPoke(0x00, 0xFF);	// DMA CSR ӥåȤ򥯥ꥢ
	X68Sound_DmaPokeL(0x0C, adrs);	// DMA MAR DMAžɥ쥹򥻥å
	X68Sound_DmaPokeW(0x0A, len);	// DMA MTC DMAžХȿ򥻥å
	SetAdpcmMode(mode, 0x88);	// ץ󥰼ȿPANꤷDMAž

	X68Sound_AdpcmPoke(0x02);	// ADPCM
}

// IOCS _ADPCMOUT ($60) ν
// []
//   void *addr : ADPCMǡɥ쥹
//   int mode : ץ󥰼ȿ(04)*256+PAN(03)
//   int len : ADPCMǡΥХȿ
void _iocs_adpcmout(void *addr, int mode, int len) {
	int dmalen;
	unsigned char *dmaadrs = (unsigned char *)addr;
	while (AdpcmStat);	// DMAžλԤ
	while (len > 0x0000FF00) {	// ADPCMǡ0xFF00ХȰʾξ
		dmalen = 0x0000FF00;	// 0xFF00ХȤʣʬDMAžԤ
		AdpcmoutMain(0x80,mode,dmalen,dmaadrs);
		dmaadrs += dmalen;
		len -= dmalen;
	}
	AdpcmoutMain(0x00,mode,len,dmaadrs);
}

// IOCS _ADPCMAOT ($62) ν
// []
//   struct _chain *tbl : 쥤ơ֥Υɥ쥹
//   int mode : ץ󥰼ȿ(04)*256+PAN(03)
//   int cnt : 쥤ơ֥Υ֥å
void _iocs_adpcmaot(struct _chain *tbl, int mode, int cnt) {
	while (AdpcmStat);	// DMAžλԤ

	AdpcmStat = 0x12;
	X68Sound_DmaPoke(0x05, 0x3A);	// DMA OCR 򥢥쥤ư

	X68Sound_DmaPoke(0x00, 0xFF);	// DMA CSR ӥåȤ򥯥ꥢ
	X68Sound_DmaPokeL(0x1C, tbl);	// DMA BAR ˥쥤ơ֥륢ɥ쥹򥻥å
	X68Sound_DmaPokeW(0x1A, cnt);	// DMA BTC ˥쥤ơ֥θĿ򥻥å
	SetAdpcmMode(mode, 0x88);	// ץ󥰼ȿPANꤷDMAž

	X68Sound_AdpcmPoke(0x02);	// ADPCM
}

// IOCS _ADPCMAOT ($64) ν
// []
//   struct _chain2 *tbl : 󥯥쥤ơ֥Υɥ쥹
//   int mode : ץ󥰼ȿ(04)*256+PAN(03)
void _iocs_adpcmlot(struct _chain2 *tbl, int mode) {
	while (AdpcmStat);	// DMAžλԤ

	AdpcmStat = 0x22;
	X68Sound_DmaPoke(0x05, 0x3E);	// DMA OCR 󥯥쥤ư

	X68Sound_DmaPoke(0x00, 0xFF);	// DMA CSR ӥåȤ򥯥ꥢ
	X68Sound_DmaPokeL(0x1C, tbl);	// DMA BAR ˥󥯥쥤ơ֥륢ɥ쥹򥻥å
	SetAdpcmMode(mode, 0x88);	// ץ󥰼ȿPANꤷDMAž

	X68Sound_AdpcmPoke(0x02);	// ADPCM
}


// ƥ˥塼⡼ɤѤADPCMϤԤץ
// IOCS _ADPCMOUT ƱԤǡХȿ0xFF00ХȰʾǤ
// ˥꥿󤹤롣
// []
//   void *addr : ADPCMǡɥ쥹
//   int mode : ץ󥰼ȿ(04)*256+PAN(03)
//   int len : ADPCMǡΥХȿ
void _iocs_adpcmcot(void *addr, int mode, int len) {
	int dmalen;
	Adpcmcot_adrs = (unsigned char *)addr;
	Adpcmcot_len = len;
	while (AdpcmStat);	// DMAžλԤ
	AdpcmStat = 0x32;

	X68Sound_DmaPoke(0x05, 0x32);	// DMA OCR ưʤ

	dmalen = Adpcmcot_len;
	if (dmalen > 0xFF00) {	// ADPCMǡ0xFF00ХȰʾξ
		dmalen = 0xFF00;	// 0xFF00ХȤʣʬDMAžԤ
	}

	X68Sound_DmaPoke(0x00, 0xFF);	// DMA CSR ӥåȤ򥯥ꥢ
	X68Sound_DmaPokeL(0x0C, Adpcmcot_adrs);	// DMA MAR DMAžɥ쥹򥻥å
	X68Sound_DmaPokeW(0x0A, dmalen);	// DMA MTC DMAžХȿ򥻥å
	Adpcmcot_adrs += dmalen;
	Adpcmcot_len -= dmalen;
	if (Adpcmcot_len <= 0) {
		SetAdpcmMode(mode, 0x88);	// ǡХȿ0xFF00ʲξ̾ž
	} else {
		dmalen = Adpcmcot_len;
		if (dmalen > 0xFF00) {
			dmalen = 0xFF00;
		}
		X68Sound_DmaPokeL(0x1C, Adpcmcot_adrs);	// BAR˼DMAžɥ쥹򥻥å
		X68Sound_DmaPokeW(0x1A, dmalen);	// BTC˼DMAžХȿ򥻥å
		Adpcmcot_adrs += dmalen;
		Adpcmcot_len -= dmalen;
		SetAdpcmMode(mode, 0xC8);	// DMA CNTӥåȤ1ˤDMAž
	}

	X68Sound_AdpcmPoke(0x02);	// ADPCM
}

// IOCS _ADPCMSNS ($66) ν
// []
//   0 : ⤷Ƥʤ
//   $02 : _iocs_adpcmout ǽ
//   $12 : _iocs_adpcmaot ǽ
//   $22 : _iocs_adpcmlot ǽ
//   $32 : _iocs_adpcmcot ǽ
int _iocs_adpcmsns() {
	return (AdpcmStat&0x7F);
}

// IOCS _ADPCMMOD ($67) ν
// []
//   0 : ADPCM λ
//   1 : ADPCM 
//   2 : ADPCM Ƴ
void _iocs_adpcmmod(int mode) {
	switch (mode) {
	case 0:
		AdpcmStat = 0;
		X68Sound_PpiCtrl(0x01);	// ADPCMOFF
		X68Sound_PpiCtrl(0x03);	// ADPCMOFF
		X68Sound_AdpcmPoke(0x01);	// ADPCMư
		X68Sound_DmaPoke(0x07, 0x10);	// DMA SAB=1 (եȥܡ)
		break;
	case 1:
		X68Sound_DmaPoke(0x07, 0x20);	// DMA HLT=1 (ۥȥڥ졼)
		break;
	case 2:
		X68Sound_DmaPoke(0x07, 0x08);	// DMA HLT=0 (ۥȥڥ졼)
		break;
	}
}


// IOCSν
// DMAγߤꤹ
void sound_iocs_init() {
	X68Sound_DmaInt(DmaIntProc);
	X68Sound_DmaErrInt(DmaErrIntProc);
}
