/*==============================================================================
	Lib MDX 使用のためのコード
	Ver 1.23
	Copyright (C) 2006 by ＳＨＩＮＴＡ
==============================================================================*/

/*==============================================================================
 Ver. |					主な改良点
--------------------------------------------------------------------------------
 ---- | 2006/01/08 (Sun) 開発着手。
 1.00 | 2006/01/08 (Sun) 主に MDX detractor のコードから構成。
 1.10 | 2006/01/08 (Sun) X68Sound_TotalVolume() へのインターフェースを用意した。
 1.20 | 2006/01/09 (Mon) PDX 検索パスを指定できるようにした。
==============================================================================*/

/*==============================================================================
==============================================================================*/

/*=== Memo =====================================================================
==============================================================================*/

//------------------------------------------------------------------------------
#include "UsingLibMDX.h"
//------------------------------------------------------------------------------
// BeOS
#include <Entry.h>
#include <File.h>
#include <FindDirectory.h>
#include <Path.h>
#include <UTF8.h>
// C++
#include <cstdio>
// Add2
#include <add2/MiscDebug.h>
// Proj
//------------------------------------------------------------------------------
int		(*TLibMDXManager::X68Sound_TotalVolume)(int oVolume);
//------------------------------------------------------------------------------
void	(*TLibMDXManager::MXDRV)(X68REG* oReg);
void	(*TLibMDXManager::MXDRV_End)();
int		(*TLibMDXManager::MXDRV_GetPCM)(void* oBuf, int oBufLen);
void volatile*	(*TLibMDXManager::MXDRV_GetWork)(int oKind);
uint32	(*TLibMDXManager::MXDRV_MeasurePlayTime)(void* oMDX,uint32 oMDXSize, void* oPDX, uint32 oPDXSize, int oLoop, int oFadeout);
void	(*TLibMDXManager::MXDRV_Play)(void* oMDX, uint32 oMDXSize, void* oPDX, uint32 oPDXSize);
void	(*TLibMDXManager::MXDRV_PlayAt)(uint32 oPlayAt, int oLoop, int oFadeout);
int		(*TLibMDXManager::MXDRV_Start)(int oSampleRate, int oBetW, int oPCMBuf, int oLatency, int oMDXBuf, int oPDXBuf, int oOPMMode);
//------------------------------------------------------------------------------
bool	TLibMDXManager::smFadeout = false;
bool	TLibMDXManager::smFadeoutStarted = false;
bool	TLibMDXManager::smMDXTerminated = false;
int32	TLibMDXManager::smLoopCount = 0;
int32	TLibMDXManager::smLoopTimes = 0;
volatile MXWORK_GLOBAL*	TLibMDXManager::smMXG = NULL;
//==============================================================================
TLibMDXManager::TLibMDXManager()
{
//	DBEXP("TLibMDXManager::TLibMDXManager()", "");
	// 初期設定
	mImgIDLibMDX = -1;
	mInitCheck = B_ERROR;
	// ライブラリロード
	Load();
	Init();
}
//------------------------------------------------------------------------------
TLibMDXManager::~TLibMDXManager()
{
	Unload();
}
//------------------------------------------------------------------------------
bigtime_t	TLibMDXManager::CurrentTime() const
{
	return static_cast<bigtime_t>(smMXG->PLAYTIME)*1024/4;
}
//------------------------------------------------------------------------------
bigtime_t	TLibMDXManager::Duration() const
{
	return mDuration;
}
//------------------------------------------------------------------------------
status_t	TLibMDXManager::FindPDXFile(const char* oPDXFileName, string* oFoundPDXFileName) const
{
	vector<string>::const_iterator	p;

//	DBEXP("TLibMDXManager::FindPDXFile() - PDX", oPDXFileName);
	p = mPDXSearchFolders.begin();
	while ( p != mPDXSearchFolders.end() ) {
//		DBEXP("TLibMDXManager::FindPDXFile", *p);
		if ( FindPDXFile(oPDXFileName, *p, oFoundPDXFileName) == B_OK )
			return B_OK;
		p++;
	}
	return B_ERROR;
}
//------------------------------------------------------------------------------
status_t	TLibMDXManager::FindPDXFile(const char* oPDXFileName, const string& oPath, string* oFoundPDXFileName) const
{
	// 拡張子が指定されている場合
	*oFoundPDXFileName = oPath+"/"+BString(oPDXFileName).ToUpper().String();
	if ( BEntry(oFoundPDXFileName->c_str()).Exists() )
		return B_OK;
	*oFoundPDXFileName = oPath+"/"+BString(oPDXFileName).ToLower().String();
	if ( BEntry(oFoundPDXFileName->c_str()).Exists() )
		return B_OK;
	// 拡張子が指定されていない場合
	*oFoundPDXFileName = oPath+"/"+BString(oPDXFileName).ToUpper().String()+".PDX";
	if ( BEntry(oFoundPDXFileName->c_str()).Exists() )
		return B_OK;
	*oFoundPDXFileName = oPath+"/"+BString(oPDXFileName).ToLower().String()+".pdx";
	if ( BEntry(oFoundPDXFileName->c_str()).Exists() )
		return B_OK;
	return B_ERROR;
}
//------------------------------------------------------------------------------
int32	TLibMDXManager::GetPCM(void* oBuf, int32 oBufLen)
{
	return MXDRV_GetPCM(oBuf, oBufLen);
}
//------------------------------------------------------------------------------
void	TLibMDXManager::GetTitle(const char* oTitle)
{
	int32		aSJISLen = strlen(oTitle);
	int32		aState = 0;
	int32		aUTF8Len = MAX_MDX_TITLE_LENGTH;

	if ( convert_to_utf8(B_SJIS_CONVERSION, oTitle, &aSJISLen, mTitle, &aUTF8Len, &aState) == B_OK ) {
		mTitle[aUTF8Len] = '\0';
	} else {
		strcpy(mTitle, oTitle);
	}
}
//------------------------------------------------------------------------------
status_t	TLibMDXManager::Init()
{
	status_t	aResult;
	MXCALLBACK_OPMINTFUNC**	aOPMINTFuncSpecifier;
	UBYTE*		aPCM8Specifier;

	try {
		if ( mImgIDLibMDX < 0 )
			throw static_cast<status_t>(B_ERROR);
		// MXWAV ソースの中の、LoadMXDRV() の一部
		if ( MXDRV_Start(OUTPUT_SAMPLE_RATE, 0, 0, 5, BUF_SIZE_MDX, BUF_SIZE_PDX, 0) != 0 )
			throw static_cast<status_t>(B_ERROR);
		// コールバック関数を MXDRV に教える
		aOPMINTFuncSpecifier = reinterpret_cast<MXCALLBACK_OPMINTFUNC**>(const_cast<void*>(MXDRV_GetWork(MXDRV_CALLBACK_OPMINT)));
		*(aOPMINTFuncSpecifier) = &MXCallBackOPMINTFunc;
		// 変数の場所を受け取る
		smMXG = reinterpret_cast<volatile MXWORK_GLOBAL*>(MXDRV_GetWork(MXDRV_WORK_GLOBAL));
		mMXFM = reinterpret_cast<volatile MXWORK_CH*>(MXDRV_GetWork(MXDRV_WORK_FM));
		mMXPCM = reinterpret_cast<volatile MXWORK_CH*>(MXDRV_GetWork(MXDRV_WORK_PCM));
		mMXOPM = reinterpret_cast<volatile MXWORK_OPM*>(MXDRV_GetWork(MXDRV_WORK_OPM));
		// static 変数初期化
		smFadeoutStarted = false;
		smMDXTerminated = false;
		smLoopCount = 0;
		// PCM8 の使用を決定
		aPCM8Specifier = reinterpret_cast<UBYTE*>(const_cast<void*>(MXDRV_GetWork(MXDRV_WORK_PCM8)));
		*(aPCM8Specifier) = 1/*smConversionPrefs.mUsePCM8*/;
		aResult = B_OK;
	} catch (status_t oErrCode) {
		aResult = oErrCode;
	}
	return aResult;
}
//------------------------------------------------------------------------------
status_t	TLibMDXManager::InitCheck() const
{
	if ( mImgIDLibMDX >= 0 && mInitCheck == B_OK )
		return B_OK;
	return B_ERROR;
}
//------------------------------------------------------------------------------
bool	TLibMDXManager::IsTerminated() const
{
	return smMDXTerminated;
}
//------------------------------------------------------------------------------
status_t	TLibMDXManager::Load()
{
	status_t	aResult;

	if ( mImgIDLibMDX > 0 )
		return B_OK;
	// ロード
	mImgIDLibMDX = load_add_on(PathNameLibMDX().c_str());
	if ( mImgIDLibMDX < 0 )
		return B_ERROR;
	// 関数取得
	try {
		// X68Sound.dll
		if ( get_image_symbol(mImgIDLibMDX, "X68Sound_TotalVolume", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&X68Sound_TotalVolume)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		// MXDRVg
		if ( get_image_symbol(mImgIDLibMDX, "MXDRV", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&MXDRV)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		if ( get_image_symbol(mImgIDLibMDX, "MXDRV_End", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&MXDRV_End)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		if ( get_image_symbol(mImgIDLibMDX, "MXDRV_GetPCM", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&MXDRV_GetPCM)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		if ( get_image_symbol(mImgIDLibMDX, "MXDRV_GetWork", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&MXDRV_GetWork)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		if ( get_image_symbol(mImgIDLibMDX, "MXDRV_Start", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&MXDRV_Start)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		if ( get_image_symbol(mImgIDLibMDX, "MXDRV_Play", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&MXDRV_Play)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		if ( get_image_symbol(mImgIDLibMDX, "MXDRV_PlayAt", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&MXDRV_PlayAt)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		if ( get_image_symbol(mImgIDLibMDX, "MXDRV_MeasurePlayTime", B_SYMBOL_TYPE_TEXT, reinterpret_cast<void **>(&MXDRV_MeasurePlayTime)) != B_OK )
			throw static_cast<status_t>(B_ERROR);
		aResult = B_OK;
	} catch (status_t oErrCode) {
		DBEXP("TLibMDXManager::Load()", "Can't load MXDRV_addon");
		aResult = oErrCode;
		Unload();
	}
	return aResult;
}
//------------------------------------------------------------------------------
void CALLBACK	TLibMDXManager::MXCallBackOPMINTFunc()
{
	if ( smMXG->L001e13 != 0 ) {
		smMDXTerminated = true;
	}
	if ( smMXG->L002246 == 65535 ) {
		smMDXTerminated = true;
	} else {
		smLoopCount = smMXG->L002246;
		if ( !smFadeoutStarted && !smMDXTerminated ) {
			if ( smLoopCount >= smLoopTimes ) {
				if ( smFadeout ) {
					smFadeoutStarted = true;
					MXDRV_Fadeout();
				} else {
					smMDXTerminated = true;
					MXDRV_Stop();
				}
			}
		}
	}
}
//------------------------------------------------------------------------------
string	TLibMDXManager::PathNameLibMDX() const
{
	BPath	aPathNameLib;

	if ( find_directory(B_USER_LIB_DIRECTORY, &aPathNameLib) != B_OK )
		return "";
	return string(aPathNameLib.Path())+"/"+FILE_NAME_LIB_MDX;
}
//------------------------------------------------------------------------------
void	TLibMDXManager::PlayAt(uint32 oPlayAt)
{
	MXDRV_PlayAt(oPlayAt, smLoopTimes, smFadeout);
}
//------------------------------------------------------------------------------
void	TLibMDXManager::SetChannelMask(int32 oChMask)
{
	smMXG->L001e1c = oChMask;
}
//------------------------------------------------------------------------------
void	TLibMDXManager::SetPDXSearchFolders(const vector<string>& oFolders)
{
	mPDXSearchFolders = oFolders;
}
//------------------------------------------------------------------------------
void	TLibMDXManager::SetPlayPrefs(int32 oLoopTimes, bool oFadeout)
{
	smLoopTimes = oLoopTimes;
	smFadeout = oFadeout;
}
//------------------------------------------------------------------------------
status_t	TLibMDXManager::SetTo(BPositionIO* oSourceIO)
{
	bool		aHasPDX = false;
	uchar		aChr;
	uchar*		aMDXBuf = NULL;
	uchar*		aPDXBuf = NULL;
	uchar*		aPtr;
	uchar*		aPtr2;
	int32		aMDXSize;
	int32		aPDXSize = 0;
	uint32		aMDXBodyPtr;
	uint32		aPDXBodyPtr;
	off_t		aMDXFileSize;
	off_t		aPDXFileSize;
	string		aPDXFileName;
	string::size_type	aPDXFileNameLenEx;
	BFile		aPDXFile;
//	BMessage	aSendMsg(PDX_ASCERTAINED);

	if ( mImgIDLibMDX < 0 )
		return B_ERROR;
	try {
//		DBEXP("TLibMDXManager::LoadMDX()", smConversionPrefs.mSrcFileName);
		// MDX 読み込み
		oSourceIO->Seek(0, SEEK_END);
		aMDXFileSize = oSourceIO->Position();
		oSourceIO->Seek(0, SEEK_SET);
		aMDXBuf = new uchar [aMDXFileSize+HEADER_SIZE_MDX_PDX];	// ??: MXDRV に渡すバッファサイズより少ないはずだが大丈夫？
		aMDXSize = oSourceIO->Read(aMDXBuf+HEADER_SIZE_MDX_PDX, aMDXFileSize);
		// タイトルをスキップ
		aPtr = aMDXBuf+HEADER_SIZE_MDX_PDX;
		while ( aMDXSize-- ) {
			aChr = *(aPtr++);
			if ( aChr == 0x0D )
				break;
			if ( aChr < 0x20 && aChr != 0x1B )
				throw static_cast<status_t>(B_ERROR);
		}
		if ( aMDXSize <= 0 )
			throw static_cast<status_t>(B_ERROR);
		aPtr--;
		*(aPtr++) = 0x00;
		if ( reinterpret_cast<uint32>(aPtr)&0x01 ) {
			*(aPtr++) = 0x00;
			aMDXSize--;
			if ( aMDXSize <= 0 )
				throw static_cast<status_t>(B_ERROR);
		}
		// PDX 読み込み
		aPtr2 = aPtr;
		while ( aMDXSize--, *(aPtr2++) != 0x1A ) {
			if ( aMDXSize <= 0 )
				throw static_cast<status_t>(B_ERROR);
		}
		if ( *(aPtr2) ) {
			DBEXP("TLibMDXManager::SetTo() - PDX file name", reinterpret_cast<char*>(aPtr2));
//			aSendMsg.AddString(MSG_NAME_PDX_FILE_NAME, reinterpret_cast<char*>(aPtr2));
//			mListenMsger.SendMessage(&aSendMsg);
			if ( FindPDXFile(reinterpret_cast<char*>(aPtr2), &aPDXFileName) == B_OK ) {
				aHasPDX = true;
//				aSendMsg.ReplaceString(MSG_NAME_PDX_FILE_NAME, aPDXFileName.c_str());
//				mListenMsger.SendMessage(&aSendMsg);
				if ( aPDXFile.SetTo(aPDXFileName.c_str(), B_READ_ONLY) != B_OK )
					throw static_cast<status_t>(B_ERROR);
				aPDXFile.GetSize(&aPDXFileSize);
//				if ( aPDXFileSize > smConversionPrefs.mPDXBufSize )
//					throw static_cast<status_t>(CE_LACKING_PDX_BUF);
				aPDXFileNameLenEx = aPDXFileName.length()+1;
				aPDXBodyPtr = (HEADER_SIZE_MDX_PDX+aPDXFileNameLenEx+1)&(-2);
				aPDXBuf = new uchar [aPDXFileSize+HEADER_SIZE_MDX_PDX+aPDXBodyPtr];
				strcpy(reinterpret_cast<char*>(aPDXBuf)+HEADER_SIZE_MDX_PDX, aPDXFileName.c_str());
				aPDXSize = aPDXFile.Read(aPDXBuf+aPDXBodyPtr, aPDXFileSize);
				aPDXBuf[0] = 0x00;
				aPDXBuf[1] = 0x00;
				aPDXBuf[2] = 0x00;
				aPDXBuf[3] = 0x00;
				aPDXBuf[4] = aPDXBodyPtr>>8;
				aPDXBuf[5] = aPDXBodyPtr;
				aPDXBuf[6] = aPDXFileNameLenEx>>8;
				aPDXBuf[7] = aPDXFileNameLenEx;
				aPDXSize += aPDXBodyPtr;
			}
		}
		// MDX を MXDRV へ渡せるよう加工する
		while ( aMDXSize--, *(aPtr2++) ) {
			if ( aMDXSize <= 0 )
				throw static_cast<status_t>(B_ERROR);
		}
		aMDXBodyPtr = aPtr-&aMDXBuf[0];
		while ( aMDXSize-- ) {
			*(aPtr++) = *(aPtr2++);
		}
		aMDXSize = aPtr-&aMDXBuf[0];
		aMDXBuf[0] = 0x00;
		aMDXBuf[1] = 0x00;
		aMDXBuf[2] = (aHasPDX ? 0 : 0xff);
		aMDXBuf[3] = (aHasPDX ? 0 : 0xff);
		aMDXBuf[4] = aMDXBodyPtr>>8;
		aMDXBuf[5] = aMDXBodyPtr;
		aMDXBuf[6] = 0x00;
		aMDXBuf[7] = 0x08;
		GetTitle(reinterpret_cast<char*>(&aMDXBuf[8]));
		// MXDRV 呼び出し
		MXDRV_Stop();
		if ( aHasPDX ) {
			mDuration = MXDRV_MeasurePlayTime(aMDXBuf, aMDXSize, aPDXBuf, aPDXSize, smLoopTimes, smFadeout)*static_cast<bigtime_t>(1000);
			MXDRV_Play(aMDXBuf, aMDXSize, aPDXBuf, aPDXSize);
		} else {
			mDuration = MXDRV_MeasurePlayTime(aMDXBuf, aMDXSize, NULL, 0, smLoopTimes, smFadeout)*static_cast<bigtime_t>(1000);
			MXDRV_Play(aMDXBuf, aMDXSize, NULL, 0);
		}
		// 
		smMXG->L001e1c = DEFAULT_CH_MASK;
		MXDRV_PlayAt(0, 1, false);
		mInitCheck = B_OK;
	} catch (status_t oErrCode) {
		mInitCheck = oErrCode;
	}
	// メモリ解放
	delete [] aMDXBuf;
	delete [] aPDXBuf;
	return mInitCheck;
}
//------------------------------------------------------------------------------
int32	TLibMDXManager::SetTotalVolume(int32 oVolume)
{
	return X68Sound_TotalVolume(oVolume);
}
//------------------------------------------------------------------------------
string	TLibMDXManager::Title() const
{
	return mTitle;
}
//------------------------------------------------------------------------------
void	TLibMDXManager::Unload()
{
	unload_add_on(mImgIDLibMDX);
	mImgIDLibMDX = -1;
}
//------------------------------------------------------------------------------
void	TLibMDXManager::Unset()
{
	if ( InitCheck() == B_OK ) {
		MXDRV_End();
	}
	mInitCheck = B_ERROR;
}
//------------------------------------------------------------------------------
//==============================================================================
