#ifndef	___UsingLibMDX_H_
#define	___UsingLibMDX_H_
//------------------------------------------------------------------------------
// BeOS
#include <be_prim.h>
#include <DataIO.h>
#include <image.h>
// C++
#include <string>
#include <vector>
// Proj
#include "mxdrv.h"
//------------------------------------------------------------------------------
const char	FILE_NAME_LIB_MDX[] = "libMDX.so";
//------------------------------------------------------------------------------
const int32	BUF_SIZE_MDX = 150*1024;
const int32	BUF_SIZE_PDX = 1024*1024;
const int32	DEFAULT_CH_MASK = 0;
const int32	HEADER_SIZE_MDX_PDX = 8;
const int32	MAX_MDX_TITLE_LENGTH = 512;	// UTF-8 変換後のタイトルの長さ最大値（これで足りるかな？）
const int32	OUTPUT_SAMPLE_RATE = 44100;
//------------------------------------------------------------------------------
//==============================================================================
/* ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
static 変数を使用しているので、利用する際には注意すること。
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''' */
class	TLibMDXManager
{
public:
	TLibMDXManager();
	virtual	~TLibMDXManager();

	bigtime_t			CurrentTime() const;
	bigtime_t			Duration() const;
	int32				GetPCM(void* oBuf, int32 oBufLen);
	status_t			Init();
	status_t			InitCheck() const;
	bool				IsTerminated() const;
	status_t			Load();
	void				PlayAt(uint32 oPlayAt);
	void				SetChannelMask(int32 oChMask);
	void				SetPDXSearchFolders(const vector<string>& oFolders);
	void				SetPlayPrefs(int32 oLoopTimes, bool oFadeout);
	virtual status_t	SetTo(BPositionIO* oSourceIO);
	int32				SetTotalVolume(int32 oVolume);
	string				Title() const;
	void				Unload();
	void				Unset();

protected:
	// X68Sound.dll の関数群
	static int	(*X68Sound_TotalVolume)(int oVolume);

	// MXDRVg の関数群
	static void	(*MXDRV)(X68REG* oReg);
	static void	(*MXDRV_End)();
	static void volatile*	(*MXDRV_GetWork)(int oKind);
	static uint32			(*MXDRV_MeasurePlayTime)(void* oMDX,uint32 oMDXSize, void* oPDX, uint32 oPDXSize, int oLoop, int oFadeout);
	static void	(*MXDRV_Play)(void* oMDX, uint32 oMDXSize, void* oPDX, uint32 oPDXSize);
	static void	(*MXDRV_PlayAt)(uint32 oPlayAt, int oLoop, int oFadeout);
	static int	(*MXDRV_GetPCM)(void* oBuf, int oBufLen);
	static int	(*MXDRV_Start)(int oSampleRate, int oBetW, int oPCMBuf, int oLatency, int oMDXBuf, int oPDXBuf, int oOPMMode);

	// 一般関数
	status_t	FindPDXFile(const char* oPDXFileName, string* oFoundPDXFileName) const;
	status_t	FindPDXFile(const char* oPDXFileName, const string& oPath, string* oFoundPDXFileName) const;
	void		GetTitle(const char* oTitle);
	string		PathNameLibMDX() const;

	// コールバック
	static void CALLBACK	MXCallBackOPMINTFunc();

	// static 変数
	static bool				smFadeout;
	static bool				smFadeoutStarted;
	static bool				smMDXTerminated;
	static int32			smLoopCount;	// 現在のループ回数
	static int32			smLoopTimes;	// ループ回数
	static volatile MXWORK_GLOBAL*	smMXG;

	char					mTitle[MAX_MDX_TITLE_LENGTH];
	bigtime_t				mDuration;		// 曲の長さ [us]
	image_id				mImgIDLibMDX;
	vector<string>			mPDXSearchFolders;
	status_t				mInitCheck;
	volatile MXWORK_CH*		mMXFM;
	volatile MXWORK_CH*		mMXPCM;
	volatile MXWORK_OPM*	mMXOPM;
};
//==============================================================================
#endif	// ___UsingLibMDX_H_
