/*==============================================================================
		デバッグ用関数群	for Zeta	Ver 1.01
		Copyright (C) 1999-2003 by ＳＨＩＮＴＡ
==============================================================================*/

/*==============================================================================
 Ver. |					主な改良点
--------------------------------------------------------------------------------
 ---- | 2003/11/15 (Sat) 開発着手。
 1.00 | 2003/11/16 (Sun) add 時代の関数を元に構築。
==============================================================================*/

/*=== Memo =====================================================================
※ヘッダを呼び出す前に DEBUG フラグをたてておくこと。
==============================================================================*/

//------------------------------------------------------------------------------
#ifdef DEBUG
#include "MiscDebug.h"
#endif
//------------------------------------------------------------------------------
#ifdef DEBUG
// BeOS
#include <Alert.h>
#include <Locker.h>
#include <Messenger.h>
#include <Roster.h>
// C++
#include <strstream>
#endif
//------------------------------------------------------------------------------
#ifdef DEBUG
BLocker		gDBEXPLocker;
#endif
//------------------------------------------------------------------------------
const char	ASSERT_CAPTION[] = "=-=-= ASSERT !!! =-=-=";
//==============================================================================
#ifdef DEBUG
//==============================================================================
void	debug_exp_if(bool oTerm, const string& oName, bool oVal)
{
	if ( oVal ) {
		debug_exp_if(oTerm, oName, "true");
	} else {
		debug_exp_if(oTerm, oName, "false");
	}
}
//------------------------------------------------------------------------------
/* ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
他の全ての debug_exp_if はこれを呼ぶ
第 2 引数の型を string にすると、文字列定数で呼んだときに void* 版が呼ばれてしまうので、char* 版と string 版の両方が必要
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''' */
void	debug_exp_if(bool oTerm, const string& oName, const char* oVal)
{
	BMessenger	aMsger;
	BMessage	aSendMsg(DBEXP_RQTD);

	if ( !oTerm )
		return;
	gDBEXPLocker.Lock();
	debug_launch_debug_host();
	aSendMsg.AddString(MSG_NAME_DB_NAME, oName.c_str());
	aSendMsg.AddString(MSG_NAME_DB_VALUE, oVal);
	aMsger = BMessenger(SIGNATURE_DEBUGHOST);	// debug_launch_debug_host() の後
	aMsger.SendMessage(&aSendMsg);
	gDBEXPLocker.Unlock();
}
//------------------------------------------------------------------------------
void	debug_exp_if(bool oTerm, const string& oName, float oVal)
{
	BString	aStream;

	aStream << oVal;
	debug_exp_if(oTerm, oName, aStream.String());
}
//------------------------------------------------------------------------------
void	debug_exp_if(bool oTerm, const string& oName, double oVal)
{
	debug_exp_if(oTerm, oName,static_cast<float>(oVal));
}
//------------------------------------------------------------------------------
void	debug_exp_if(bool oTerm, const string& oName, const void* oVal)
{
	char		aTmp[1024];
	ostrstream	aOut(aTmp, sizeof(aTmp));

	if ( oVal != NULL ) {
		aOut << hex << reinterpret_cast<int32>(oVal) << ends;
	} else {
		aOut << "NULL" << ends;
	}
	debug_exp_if(oTerm, oName, aTmp);
}
//------------------------------------------------------------------------------
void	debug_exp_if(bool oTerm, const string& oName, const string& oVal)
{
	if ( oTerm ) {
		debug_exp_if(oTerm, oName, oVal.c_str());
	}
}
//------------------------------------------------------------------------------
void	debug_exp_if(bool oTerm, const string& oName, const BRect& oVal)
{
	BString	aStream;

	aStream << static_cast<int32>(oVal.left) << ", " << static_cast<int32>(oVal.top) << ", " <<
			static_cast<int32>(oVal.right) << ", " << static_cast<int32>(oVal.bottom) << '\0';
	debug_exp_if(oTerm, oName, aStream.String());
}
//------------------------------------------------------------------------------
void	debug_launch_debug_host()
{
	if ( !be_roster->IsRunning(SIGNATURE_DEBUGHOST) ) {
		be_roster->Launch(SIGNATURE_DEBUGHOST);
	}
}
//------------------------------------------------------------------------------
void	debug_assert(bool oAssert, const char* oMsg, const char* oFileName, int oLine)
{
	char		aTmp[1024];
	ostrstream	aOut(aTmp, sizeof(aTmp));
	BAlert*		aAlert;

	if ( !oAssert )
		return;
	aOut << ASSERT_CAPTION << "\n\n" << oMsg << "\n" << oFileName << "\nLine " << oLine << ends;
	aAlert = new BAlert("Title", aTmp, "OK", NULL, NULL, B_WIDTH_AS_USUAL, B_OFFSET_SPACING, B_WARNING_ALERT);
	aAlert->Go();
}
//------------------------------------------------------------------------------
void	debug_ssert_console(bool oAssert, const char* oMsg, const char* oFileName, int oLine)
{
	char		aTmp[1024];
	ostrstream	aOut(aTmp, sizeof(aTmp));

	if ( !oAssert )
		return;
	aOut << oMsg << "\n" << oFileName << "\nLine " << oLine << ends;
	DBEXP(aTmp, ASSERT_CAPTION);
}
//------------------------------------------------------------------------------
void	debug_show_msg_info(const BMessage& oMsg)
{
	const char*	aName;
	int32		aNumNames;
	string		aStr;
	type_code	aTypeCode;
	BAlert*		aAlert;

	aNumNames = oMsg.CountNames(B_ANY_TYPE);
	aStr = "* Names *\n";
	for ( int i = 0 ; i < aNumNames ; i++ ) {
		oMsg.GetInfo(B_ANY_TYPE, i, &aName, &aTypeCode);
		aStr += "\""+string(aName)+"\" \t[";
		switch ( aTypeCode ) {
		case B_BOOL_TYPE:
			aStr += "Bool";
			break;
		case B_INT8_TYPE:
			aStr += "Int8";
			break;
		case B_INT16_TYPE:
			aStr += "Int16";
			break;
		case B_INT32_TYPE:
			aStr += "Int32";
			break;
		case B_INT64_TYPE:
			aStr += "Int64";
			break;
		case B_UINT8_TYPE:
			aStr += "U Int8";
			break;
		case B_UINT16_TYPE:
			aStr += "U Int16";
			break;
		case B_UINT32_TYPE:
			aStr += "U Int32";
			break;
		case B_UINT64_TYPE:
			aStr += "U Int64";
			break;
		case B_FLOAT_TYPE:
			aStr += "Float";
			break;
		case B_DOUBLE_TYPE:
			aStr += "Double";
			break;
		case B_STRING_TYPE:
			aStr += "String";
			break;
		case B_POINT_TYPE:
			aStr += "Point";
			break;
		case B_RECT_TYPE:
			aStr += "Rect";
			break;
		case B_REF_TYPE:
			aStr += "Entry Ref";
			break;
		case B_MESSAGE_TYPE:
			aStr += "Message";
			break;
		case B_MESSENGER_TYPE:
			aStr += "Messenger";
			break;
		case B_POINTER_TYPE:
			aStr += "Pointer";
			break;
		default:
			aStr += "Other:"+string(1, aTypeCode>>24)+string(1, static_cast<char>(aTypeCode>>16))
					+string(1, static_cast<char>(aTypeCode>>8))+string(1, static_cast<char>(aTypeCode));
		}
		aStr += "]\n";
	}
	aAlert = new BAlert("Title", aStr.c_str(), "OK", NULL, NULL, B_WIDTH_AS_USUAL, B_OFFSET_SPACING);
	aAlert->Go();
}
//------------------------------------------------------------------------------
//==============================================================================
#endif	// DEBUG
//==============================================================================
