#ifndef	___MiscDebug_H_
#define	___MiscDebug_H_
//------------------------------------------------------------------------------
// Rect
#include <Message.h>
#include <Rect.h>
#include <String.h>
// C++
#include <string>
//------------------------------------------------------------------------------
const uint32	DBEXP_RQTD = '_der';			// DBEXP 要求
//------------------------------------------------------------------------------
const char	MSG_NAME_DB_NAME[] = "Name";
const char	MSG_NAME_DB_VALUE[] = "Value";
const char	SIGNATURE_DEBUGHOST[] = "application/x-vnd.SHINTA-DebugHost";
//------------------------------------------------------------------------------
#undef	ASSERT
//==============================================================================
#ifdef DEBUG
#define ASSERT(oAssert, oMsg)		debug_assert((oAssert), (oMsg), __FILE__, __LINE__)
		// バグ（内部エラー）の告知
		// oAssertが真なら告知
		// 実行時エラーには使用してはならない
#define ASSERTC(bAssert,cMsg)		debug_assert_console((oAssert), (oMsg), __FILE__, __LINE__)
		// コンソール用
#define	DBEXP(oName, oVal)			debug_exp_if(true, (oName), (oVal))
		// 情報をデバッグウィンドウに表示
#define	DBEXPIF(oTerm, oName, oVal)	debug_exp_if((oTerm), (oName), (oVal))
		// oTerm が true の時のみ情報をデバッグウィンドウに表示
#define	DBSHOWMSGINFO(oMsg)			debug_show_msg_info(oMsg)
		//メッセージのメンバを表示
#else
#define	ASSERT(oAssert, oMsg)
#define	ASSERTC(oAssert, oMsg)
#define	DBEXP(oName, oVal)
#define	DBEXPIF(oTerm, oName, oVal)
#define	DBSHOWMSGINFO(oMsg)
#endif
//==============================================================================
#ifdef DEBUG
//==============================================================================
void	debug_exp_if(bool oTerm, const string& oName, bool oVal);
void	debug_exp_if(bool oTerm, const string& oName, const char* oVal);
void	debug_exp_if(bool oTerm, const string& oName, float oVal);
void	debug_exp_if(bool oTerm, const string& oName, double oVal);
void	debug_exp_if(bool oTerm, const string& oName, const void* oVal);
void	debug_exp_if(bool oTerm, const string& oName, const string& oVal);
void	debug_exp_if(bool oTerm, const string& oName, const BRect& oVal);
void	debug_launch_debug_host();
void	debug_assert(bool oAssert, const char* oMsg, const char* oFileName, int oLine);
void	debug_ssert_console(bool oAssert, const char* oMsg, const char* oFileName, int oLine);
void	debug_show_msg_info(const BMessage& oMsg);
//------------------------------------------------------------------------------
// テンプレート群
template <class T>
void	debug_exp_if(bool oTerm, const string& oName, T oVal)	// 整数用 debug_exp_if()
{
	BString	aStream;

	aStream << oVal;
	debug_exp_if(oTerm, oName, aStream.String());
}
//==============================================================================
#endif	// DEBUG
//==============================================================================
#endif	// ___MiscDebug_H_
