#!/bin/sh

alert --info "This will install the ipw2100 driver." "Cancel" "OK"
if [ $? == 0 ]; then exit; fi

cd `dirname $0`
mkdir -p /var/tmp/ipw2100
unzip -o install.zip -d /var/tmp/ipw2100

mkdir -p /etc/firmware/ipw2100
unzip -o /var/tmp/ipw2100/ipw2100-fw-1.3.zip -d /etc/firmware/ipw2100

StyledEdit /etc/firmware/ipw2100/LICENSE &

alert --info "Please read the license agreement for the firmware images. Do you agree to these terms?" "I don't" "I agree"
if [ $? == 0 ]; then
	alert --info "The installation was canceled."
	rm -r /var/tmp/ipw2100
	exit
fi

copyattr -d /var/tmp/ipw2100/ipw2100.addon /boot/beos/system/add-ons/net_server/ipw2100
copyattr -d /var/tmp/ipw2100/ipw2100 /boot/home/config/add-ons/kernel/drivers/bin/ipw2100
ln -s ../../bin/ipw2100 /boot/home/config/add-ons/kernel/drivers/dev/net
rescan ipw2100

if [ -f /boot/home/config/settings/kernel/drivers/ipw2100 ]; then
	alert --warning "There is already a settings file present, do you want to preserve or overwrite it?" "Overwrite" "Preserve"
	if [ $? == 0 ]; then copyattr -d /var/tmp/ipw2100/ipw2100.settings /boot/home/config/settings/kernel/drivers/ipw2100; fi
else
	copyattr -d /var/tmp/ipw2100/ipw2100.settings /boot/home/config/settings/kernel/drivers/ipw2100
fi

rm -r /var/tmp/ipw2100

alert --info "The driver has been installed. Would you like to edit the settings file now? After that you can go on setting up the network configuration." "Quit" "Edit Settings"
if [ $? == 0 ]; then exit; fi

StyledEdit /boot/home/config/settings/kernel/drivers/ipw2100
