#include "GenericProxy.h"

GenericProxy::GenericProxy( int32 socket, DNSResolver *nameResolver, 
	TCPListener *threadManager, const char *host, uint16 port )
	: TCPProxy( socket, nameResolver, threadManager, 16384, 60000000, 250000 )
{
	strncpy( this->host, host, 255 );
	this->port = port;
}

status_t GenericProxy::Connect( void )
{
	int32		size;
	status_t	status;
	sockaddr_in	serverAddr;
	int32		ip_addr;
	
	if( (serverSocket = socket( AF_INET, SOCK_STREAM, 0 )) < 0 )
		return errno;
	
	if( (status = nameResolver->ResolveName( host, &ip_addr )) != B_NO_ERROR )
		return status;
	
	// Init address
	serverAddr.sin_family = AF_INET;
	serverAddr.sin_port = htons( port );
	serverAddr.sin_addr.s_addr = ip_addr;
	memset(serverAddr.sin_zero, 0, sizeof(serverAddr.sin_zero));
	
	if( (connect( serverSocket, (sockaddr *)&serverAddr, sizeof(serverAddr) )) < 0 )
		return errno;
	recvSocket = serverSocket;
	sendSocket = clientSocket;
	
	return B_NO_ERROR;
}