#include "LocalRez.h"

LocalResource::LocalResource( void )
{
	BFile 			resFile;
	app_info 		info;
	status_t		status;
	
	be_app->GetAppInfo( &info );
	
	if( (status = resFile.SetTo( &info.ref, B_READ_ONLY )) == B_OK )
		SetTo( &resFile );
}

void *LocalResource::ReadRez( type_code type, int32 id, off_t offset, size_t *length )
{
	const char 		*name;
	size_t			size;
	void			*rez;
	status_t		status;
	
	if( GetResourceInfo( type, id, &name, &size ) )
	{
		size -= offset;
		*length = size;
		
		if( (rez = malloc( size )) == NULL )
			return NULL;
		if( (status = ReadResource( type, id, rez, offset, size )) == B_NO_ERROR )
			return rez;
		else
		{	
			free( rez );
			return NULL;
		}
	}
	else
		return NULL;
}
