#include "ProxyAdmin.h"
#include "ProxyAppMsg.h"
#include "AdminCon.h"
#include "LocalRez.h"
#include "HTTPUtils.h"

ProxyAdmin::ProxyAdmin( const BMessenger *messenger, uint16 port )
	: TCPListener( "HTTP Proxy Admin Server", 4, port )
{
	LocalResource		localRez;
	
	this->messenger = new BMessenger( *messenger );
	
	// Load HTML Body Resources
	head = (char *)localRez.ReadRez( 'CSTR', 1, 0, &headSize );
	foot = (char *)localRez.ReadRez( 'CSTR', 0, 0, &footSize );
	tableRow = (char *)localRez.ReadRez( 'CSTR', 2, 0, &tableRowSize );
	
	// Get USERNAME and PASSWORD from "network" settings
	LoadNetworkSettings();
}

ProxyAdmin::~ProxyAdmin( void )
{
	delete messenger;
	free( head );
	free( foot );
	free( tableRow );
}

TCPConnection *ProxyAdmin::NewConnection( int32 socket )
{
	return new AdminConnection( socket, this, messenger );
}

const char *ProxyAdmin::GetBodyHead( size_t *size )
{
	*size = headSize;
	return head;
}

const char *ProxyAdmin::GetBodyFoot( size_t *size )
{
	*size = footSize;
	return foot;
}

const char *ProxyAdmin::GetTableRow( size_t *size )
{
	*size = tableRowSize;
	return tableRow;
}

const char *ProxyAdmin::GetUser( void )
{
	return user;
}

const char *ProxyAdmin::GetPass( void )
{
	return pass;
}

status_t ProxyAdmin::LoadNetworkSettings( void )
{
	BPath			path;
	BDirectory		dir;
	BFile			file;
	off_t			bigSize;
	size_t			size;
	char			*netfile;
	char 			*sPtr;
	
	// Locate and open file /boot/home/settings/config/network
	if( (status = find_directory( B_USER_SETTINGS_DIRECTORY, &path)) != B_NO_ERROR )
		return status;
		
	dir.SetTo( path.Path() );
	if( (status = file.SetTo( &dir, "network", B_READ_ONLY )) != B_NO_ERROR )
		return status;
	
	// Get file size
	file.GetSize( &bigSize );
	size = bigSize;
	
	// Read network prefs into buffer
	netfile = (char *)malloc( size+1 );
	file.Read( netfile, size );
	netfile[size] = 0;
	
	// Get the username from prefs
	sPtr = http_find_header( netfile, "USERNAME = ", &size );
	memmove( user, sPtr, size );
	user[size] = 0;
	
	// Get encrypted password from prefs
	sPtr = http_find_header( netfile, "PASSWORD = ", &size );
	memmove( pass, sPtr, size );
	pass[size] = 0;
	
	free( netfile );
	return B_NO_ERROR;
}
