/******************************************************************************
//
//	File:		ProxyApp.h
//
//	Description:	
//
//	Copyright 1998, Joe Kloss
//
*******************************************************************************/

#ifndef PROXY_APP_H
#define PROXY_APP_H

#include "ProxyManager.h"
#include "ProxyAppMsg.h"
#include "ProxyAdmin.h"

class ProxyApp : public BApplication
{
	public:
		ProxyApp( void );
		~ProxyApp( void );
		
		virtual void MessageReceived( BMessage *message );
		virtual void ReadyToRun( void );
		virtual void Quit( void );
		
	protected:
		void StartAllProxies( void );
		void ShutdownProxies( void );
		
		void StopProxies( BMessage *message );
		void StartProxies( BMessage *message ); // starts all proxies specified in message
		void GetProxies( BMessage *message ); // Fills the message with proxy info
		
		status_t GetConfigFile( BFile *file, int32 openMode ); // file->SetTo( configFile, openMode )
		status_t SaveConfig( BMessage *config ); // Flattens config in configFile
		status_t LoadConfig( BMessage *config ); // Unflattens config from config file or sets to default config if failure
		
	protected:
		ProxyAdmin			*admin;
		BList				*proxyMList;
		DNSResolver			*nameResolver;
		bool				go;
};

#endif