/******************************************************************************
//
//	File:		DNSResolver.h
//
//	Description: Socket related utilities
//	Includes:
//		- A thread-safe DNS Resolver class
//		- can_read_datagram() function to check for data before committing to a recv() call
//	
//
//	Copyright 1998, Joe Kloss
//
*******************************************************************************/

#ifndef SOCKET_TOOLS_H
#define SOCKET_TOOLS_H

#include <netdb.h>
#include "benaphore.h"

class DNSResolver
{
	public:
		DNSResolver( void );
		~DNSResolver( void );
	
	public:
		status_t ResolveName( const char *hostAddrStr, int32 *ip_addr );
	
	protected:
		Benaphore		*resolveLock;
		char			lastHost[256];
		int32			last_ip;
};

bool can_read_datagram( int32 socket, int32 timeout_usec = 0, int32 timeout_sec = 2 );

#endif