#ifndef TCP_LISTENER_H
#define TCP_LISTENER_H

#include "TCPConnection.h"
#include "benaphore.h"

#define MSG_LISTENER_TERMINATED		'LteM'
extern const char *kListenerPtr;

class TCPListener
{
	friend TCPConnection;
	
	public:
		TCPListener( const char *name, int32 maxConnections, int32 port );
		virtual ~TCPListener( void );
		
		virtual thread_id Run( void ); // Similar to BLooper
		virtual void Quit( void );
		
		int32 GetTotalConnections( void );
		int32 GetCurrentConnections( void );
		int32 GetMaxConnections( void );
		uint16 GetLocalPort( void );
		const char *GetName( void );
		
		
	protected:
		static int32 thread_entry_point( void *arg );
		int32 ListenThread( void );
		virtual TCPConnection *NewConnection( int32 socket ) = 0;
		int32 DeleteConnection( TCPConnection *theConnection );
		
	protected:
		char		*name;
		thread_id	listenThread;
		int32		listenSocket;
		int32		localPort;
		sockaddr_in	serverAddr;
		
		int32		maxConnections;
		int32		totalConnections;
		status_t	status;
		bool		listenStat;
		
		BList		*threadList;
		Benaphore	*listAccessBen;
};

#endif
