// 1997 Joe Kloss

#include "benaphore.h"

Benaphore::Benaphore( int32 threadCount, const char *name )
{
	ben_val =  threadCount - 1;
	sem = create_sem( ben_val, name );
}

Benaphore::~Benaphore( void )
{
	delete_sem( sem );
}

status_t Benaphore::Acquire( void )
{
	previous = atomic_add( &ben_val, 1 );
	if( previous >= 1 )
		return acquire_sem( sem );
	else
		return B_NO_ERROR;
}

status_t Benaphore::Acquire( uint32 count, uint32 flags, bigtime_t timeout )
{
	
	previous = atomic_add( &ben_val, count );
	if( previous >= 1 )
		return acquire_sem_etc( sem, count, flags, timeout );
	else
		return B_NO_ERROR;
}

status_t Benaphore::Release( void )
{
	previous = atomic_add( &ben_val, -1 );
	if( previous > 1 )
		return release_sem( sem );
	else
		return B_NO_ERROR;
}

status_t Benaphore::Release( uint32 count, uint32 flags )
{
	previous = atomic_add( &ben_val, -count );
	if( previous > 1 )
		return release_sem_etc( sem, count, flags );
	else
		return B_NO_ERROR;
}