/******************************************************************************
//
//	File:		ProxyManager.h
//
//	Description: Responsible for listening for connections and managing 
//	proxy threads. Could be used to retrieve information about connections
//	and statistics.
//
//	Copyright 1998, Joe Kloss
//
*******************************************************************************/

#ifndef PROXY_MANAGER_H
#define PROXY_MANAGER_H

#include "TCPListener.h"
#include "SocketTools.h"

class ProxyManager : public TCPListener
{
	public:
		ProxyManager( DNSResolver *nameResolver, const char *name, 
			int32 maxConnections, int32 port );
		
		virtual int32 GetType( void ) = 0;
		
	protected:
		DNSResolver *nameResolver;
};

class HTTPProxyManager : public ProxyManager
{
	public:
		HTTPProxyManager( DNSResolver *nameResolver, const char *name, uint16 port = 8080, int32 maxConnections = 32 );
		
	protected:
		virtual TCPConnection *NewConnection( int32 socket );
		virtual int32 GetType( void );
};

class GenericProxyManager : public ProxyManager
{
	public:
		GenericProxyManager( DNSResolver *nameResolver, const char *name, 
			uint16 localPort, const char *host, uint16 remotePort, int32 maxConnections = 32 );
		
		const char *GetHost( void );
		uint16 GetRemotePort( void );
		
	protected:
		virtual TCPConnection *NewConnection( int32 socket );
		virtual int32 GetType( void );
	
	protected:
		char		host[256];
		uint16		remotePort;
};

#endif
