/******************************************************************************
//
//	File:		HTTPProxy.h
//
//	Description: HTTP Proxy connection; forwards request to server;
// 	forwards reply back to client
//
//	Copyright 1998, Joe Kloss
//
*******************************************************************************/

#ifndef HTTP_PROXY_H
#define HTTP_PROXY_H

#include "Proxy.h"

// Message Stuff ( sent to thread manager when done )
extern const char *kHPPointer; // Pointer to terminating HTTPProxy
#define HP_TERMINATE 'PMtm'

class HTTPProxy : public TCPProxy
{
	public:
		HTTPProxy( int32 socket, DNSResolver *nameResolver, TCPListener *threadManager, int32 bufSize = 16384 );
		~HTTPProxy( void );
		
	protected:
		virtual void HandleError( status_t error );
		virtual status_t Connect( void );
		
		status_t ResolveURI( const char *uri, sockaddr_in *addr ); // get host IP address from URI
		status_t GetHostStr( const char *uri, char *hostStr, uint16 *port ); // get the host IP name from a URI
		status_t StripNetPath( char *httpRequest, int32 &size ); // Removes the net path from a request ( http://www.be.com/stuff/index.html becomes /stuff/index.html
		status_t SendHTTPMessage( const char *title, const char *msgBody ); // send a message to the client in HTML format
		status_t SendErrorMsg( const char *errStr );
};

#endif
