// HTTP/1.0 See RFC1945

#ifndef HTTP_UTILS_H
#define HTTP_UTILS_H

// Add escape characters to C String to make valid for use in URI
size_t esc_c_str( char *dst, const char *src, size_t bufSize );
size_t unescape_c_str( char *dst, const char *src, size_t bufSize );

// Message Formatting Utilities
void http_wstatus_line( BPositionIO *io, int32 code );
void http_wcontent_length( BPositionIO *io, int32 length );
void http_wcontent_type( BPositionIO *io, const char *type );
void http_wserver_type( BPositionIO *io, const char *type );
void http_wdate( BPositionIO *io, const tm *time );
void http_wexpires( BPositionIO *io, const tm *time );
void http_wnocache( BPositionIO *io );
void http_wrefresh( BPositionIO *io, const char *time, const char *url );
void http_wauthenticate( BPositionIO *io, const char *realm );
void http_wcrlf( BPositionIO *io ); // "/r/n"

// Message Scanning Utilities
char *http_find_header( const char *msg, const char *headName, size_t *length );
char *http_find_uri( const char *msg, size_t *length );
char *http_find_msg_body( const char *msg );

enum http_method { METHOD_POST, METHOD_GET, METHOD_HEAD, METHOD_UNKNOWN };
http_method http_find_method( const char *msg );

char *traverse_path( const char *path, size_t *length ); // returns next path element of url or NULL if end of path encountered
char *find_post_element( const char *msg, const char *name, size_t *length );
status_t get_post_cstring( const char *msg, const char *name, char *buffer, size_t bufSize );
#endif
