#ifndef PROXY_APP_MSG_H
#define PROXY_APP_MSG_H

// Proxy Types
#define HTTP_PROXY_TYPE 'HttP'
#define GENERIC_PROXY_TYPE 'GenR'

// Messages
#define MSG_RESET_PROXY	'RseT'

#define MSG_STOP_PROXY 'StoP'
extern const char *kProxyName; // String; Name of Proxy

#define MSG_START_PROXY 'NewP'
extern const char *kProxyType; // int32; proxy_type ( see above )
// kProxyName: String; Name of Proxy
extern const char *kProxyLocalPort;  // int16; Local port ( actually a uint16 )
extern const char *kProxyMaxCon; // int32; maximum connections ( optional )
// Required for generic_proxy_type
extern const char *kProxyHost; // String; Remote host name
extern const char *kProxyRemotePort; // int16; Remote port


#define MSG_GET_PROXIES 'PgeT' // Request info about proxies
#define MSG_PROXIES 'PrxY' // Reply to above
// Sends one for each proxy
//kProxyType: int32; proxy_type ( see above )
//kProxyName: String; Name of Proxy
//kProxyLocalPort: int16; Local port ( actually a uint16 )
//kProxyMaxCon: int32; maximum connections
extern const char *kProxyHits; // int32; total number of connections
extern const char *kProxyCon; // int32; current number of connections
// Sent only for generic_proxy_type
//kProxyHost: String; Remote host name
//kProxyRemotePort: int16; Remote port

#endif