#include "SocketTools.h"

DNSResolver::DNSResolver( void )
{
	resolveLock = new Benaphore( 1, "DNS_Lock" );
	lastHost[0] = 0;
}

DNSResolver::~DNSResolver( void )
{
	delete resolveLock;
}

status_t DNSResolver::ResolveName( const char *hostAddrStr, int32 *ip_addr )
{
	// Check cache
	if( strcmp( hostAddrStr, lastHost ) == 0 )
	{
		*ip_addr = last_ip;
		return B_NO_ERROR;
	}
	
	// Make sure it's only accessed by one thread at a time
	resolveLock->Acquire();
	
	hostent		*theHost;
	status_t	status;
	
	if( !(theHost = gethostbyname( hostAddrStr )) )
	{
		status = h_errno;
		resolveLock->Release();
		return status;
	}
	*ip_addr = *(int32 *)theHost->h_addr_list[0];
	
	// Cache it
	strncpy( lastHost, hostAddrStr, 255 );
	last_ip = *ip_addr;
	resolveLock->Release();
	
	return B_NO_ERROR;
}

// From the BeBook:The Network Kit:Sockets socket.h
bool can_read_datagram( int32 socket, int32 timeout_usec, int32 timeout_sec ) 
{
	struct timeval tv; 
	struct fd_set fds; 
	
	tv.tv_sec = timeout_sec; 
	tv.tv_usec = timeout_usec; 
	
	/* Initialize (clear) the socket mask. */ 
	FD_ZERO(&fds); 
	
	/* Set the socket in the mask. */ 
	FD_SET(socket, &fds);
	if( select(socket + 1, &fds, NULL, NULL, &tv) == -1 )
		return -1;
	
	/* If the socket is still set, then it's ready to read. */ 
	return FD_ISSET(socket, &fds); 
}
