#ifndef TCP_CONNECTION_H
#define TCP_CONNECTION_H

// Message Stuff ( sent to thread manager when done )
extern const char *kHPPointer; // Pointer to terminating Connection
#define HP_TERMINATE 'PMtm'

// TCPConnection specific errors
#define CONNECTION_TERMINATED -10000

extern class TCPListener;

class TCPConnection
{
	public:
		TCPConnection( int32 socket, TCPListener *threadManager );
		virtual ~TCPConnection( void );
		virtual status_t Run( void ) = 0; // Similar to BLooper
		virtual void Quit( void );
		
		int32 GetPSN( void ); // get serial number; used for debugging
	
	protected:
		virtual void Shutdown( status_t error ); // Called when connection can't continue
			
	protected:
		int32			psn;
		int32 			clientSocket;
		TCPListener		*threadManager; // Posts PM_TERMINATE to threadManager when connection is closed
};

#endif
