light
ppSpotLight ( float intensity = 1;
        color lightcolor = 1;
        point from = point "shader" (0,0,0);
        point to = point "shader" (0,0,1);
        float conefull = 0.349;
        float coneoff = 0.7854;
        float fadebegin = 0;
        float fadeend = 0;)
{
  float atten, cosangle, dist, dist2;
  uniform vector A = normalize(to-from);

  illuminate (from) {
    if (fadebegin >= 0 && fadeend > 0) {
      dist2 = L . L;
      dist = sqrt(dist2);
      if(dist > fadebegin) {
        if(dist < fadeend) {
          atten = ((fadeend*fadeend) - dist2) / 
                  ((fadeend*fadeend) - (fadebegin*fadebegin));
        }
        else {
          atten = 0.0;
        }
      }
      else {
        atten = 1.0;
      }
    }
    else {
      atten = 1.0;
    }

    cosangle = (L . A) / length(L);
    atten *= smoothstep (cos(coneoff), cos(conefull), cosangle);
    Cl = atten * intensity * lightcolor ;
  }
}

