//
//
//	Add-ons Roster
//
//											(C) JoOl 1998


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Application.h>
#include <NodeMonitor.h>
#include <Path.h>
#include <Directory.h>

#include "AddOnsRoster.h"
#include "PlainAddOn.h"


AddOnsRoster::AddOnsRoster(BListView* l, const char* nam, uint32 sbars)
: RitemsList(l, nam, sbars)
{
}


AddOnsRoster::~AddOnsRoster()
{
	Reset();
}


int32
AddOnsRoster::cmpPlainAddOns(Pitem* i1, void* i2)
{
	PlainAddOn*			p1 = (PlainAddOn* )i1;
	PlainAddOn*			p2 = (PlainAddOn* )i2;
	if (p1->Eq(&p2->GetLinkRef())
		|| p1->Eq(&p2->GetLinkNodeRef()))
		return 0;
	return -1;
}


int32
AddOnsRoster::cmpPlainAddOnRefs(Pitem* i1, void* i2)
{
	if (((PlainAddOn* )i1)->Eq((entry_ref* )i2))
		return 0;
	return -1;
}


int32
AddOnsRoster::cmpPlainAddOnNodeRefs(Pitem* i1, void* i2)
{
	if (((PlainAddOn* )i1)->Eq((node_ref* )i2))
		return 0;
	return -1;
}


int32
AddOnsRoster::CountItems() const
{
	return RitemsList::CountItems();
}


PlainAddOn*
AddOnsRoster::ItemAt(int32 i) const
{
	return (PlainAddOn* )RitemsList::ItemAt(i);
}


void
AddOnsRoster::Reset()
{
	while (CountItems() > 0)
	{
		PlainAddOn*		ao = (PlainAddOn* )RemoveItem(CountItems()-1);
		printf("- %s\n", ao->GetLabel());
		ao->Unset();
		delete ao;
	}

	stop_watching(be_app_messenger);
}


bool
AddOnsRoster::SetFromEnv(const char* var, AddOnConstructor constructor)
{
	BPath				appliPath;
	BPath				currentPath;

	// Determine the directory containing the application executable
	app_info			appliInfo;
	be_app->GetAppInfo(&appliInfo);
	BEntry				appliEntry(&appliInfo.ref, true);
	appliEntry.GetPath(&appliPath);
	appliPath.GetParent(&appliPath);

	// Determine the paths of the various add-on directories (environment)
	char*				aoPaths = getenv(var);
	if (!aoPaths)
		return false;

	char*		start = aoPaths;
	char*		end;
	// Parse the environment variable
	while (*start)
	{
		if (!strncmp(start, "%A/", 3))
			start += 3;
		currentPath.SetTo(appliPath.Path());

		end = strchr(start, ':');
		bool			last = false;
		if (!end)
		{
			last = true;
			end = start + strlen(start);
		}
		else
			*end = 0;

		if (*start == '/')
			currentPath.SetTo(start);
		else
			currentPath.Append(start);
		start = end;
		if (!last)
		{
			*end = ':';				// useless
			start++;
		}

		Explore(currentPath.Path(), constructor);
	}
	return true;
}


bool
AddOnsRoster::Explore(const char* path, AddOnConstructor constructor)
{
	struct stat		st;
	BDirectory		currentDir(path);
	currentDir.GetStat(&st);
	if (S_ISDIR(st.st_mode) && (currentDir.InitCheck() == B_OK))
	{
		// Loop over the current directory's entries
		image_id		currentAddOn;
		BEntry			addOnEntry;
		while (currentDir.GetNextEntry(&addOnEntry) == B_OK)
		{
			if (Insert(addOnEntry, constructor))
			{
				BPath	p;
				addOnEntry.GetPath(&p);
				printf("+ %s\n", p.Path());
			}
		}

		node_ref		dirRef;
		currentDir.GetNodeRef(&dirRef);
		if (watch_node(&dirRef, B_WATCH_DIRECTORY, be_app_messenger) != B_NO_ERROR)
			return false;
	}
	return true;
}


bool
AddOnsRoster::Insert(entry_ref r, AddOnConstructor constructor)
{
	BEntry			e(&r, false);
	if (e.InitCheck() != B_NO_ERROR)
		return false;
	return Insert(e, constructor);
}


bool
AddOnsRoster::Insert(BEntry e, AddOnConstructor constructor)
{
	BPath			p;
	e.GetPath(&p);
	return Insert(p.Path(), constructor);
}


bool
AddOnsRoster::Insert(const char* path, AddOnConstructor constructor)
{
	entry_ref		r;
	struct stat		st;
	BEntry			e(path, true);
	if (e.InitCheck() != B_NO_ERROR)
		return false;
	e.GetRef(&r);
	e.GetStat(&st);
	if (!S_ISREG(st.st_mode))
		return false;
/*	bool			out = false;
	if (Window()->Lock())
	{
		out = DoInsert(path, constructor);
		Window()->Unlock();
	}
	return out;
*/
	return DoInsert(path, constructor);
}


bool
AddOnsRoster::DoInsert(const char* path, AddOnConstructor constructor)
{
	PlainAddOn*		aoi = constructor();
//	if (!aoi->SetTo((char* )path) || Exists(cmpPlainAddOns, (void* )aoi))
	if (!aoi->SetTo((char* )path) || Exists(Pitem::cmpPitems, (void* )aoi))
	{
		aoi->Unset();
		delete aoi;
		return false;
	}

	return AddItem(cmpPlainAddOns, aoi);
}


PlainAddOn*
AddOnsRoster::Remove(node_ref nref)
{
/*	PlainAddOn*			out = NULL;
	if (Window()->Lock())
	{
		out = (PlainAddOn* )RemoveItem(cmpPlainAddOnNodeRefs, &nref);
		Window()->Unlock();
	}
	return out;
*/
	return (PlainAddOn* )RemoveItem(cmpPlainAddOnNodeRefs, &nref);
}


PlainAddOn*
AddOnsRoster::Remove(entry_ref ref)
{
/*	PlainAddOn*			out = NULL;
	if (Window()->Lock())
	{
		out = (PlainAddOn* )RemoveItem(cmpPlainAddOnRefs, &ref);
		Window()->Unlock();
	}
	return out;
*/
	return (PlainAddOn* )RemoveItem(cmpPlainAddOnRefs, &ref);
}


bool
AddOnsRoster::Delete(node_ref nref)
{
/*	bool			out = false;
	if (Window()->Lock())
	{
		out = DeleteItem(cmpPlainAddOnNodeRefs, &nref);
		Window()->Unlock();
	}
	return out;
*/
	return DeleteItem(cmpPlainAddOnNodeRefs, &nref);
}


bool
AddOnsRoster::Delete(entry_ref ref)
{
/*	bool			out = false;
	if (Window()->Lock())
	{
		out = DeleteItem(cmpPlainAddOnRefs, &ref);
		Window()->Unlock();
	}
	return out;
*/
	return DeleteItem(cmpPlainAddOnRefs, &ref);
}


PlainAddOn*
AddOnsRoster::Filter(AddOnFilter f, void* arg) const
{
	for (int32 i = 0; i < CountItems(); i++)
	{
		PlainAddOn*			curr = ItemAt(i);
		if (f(curr, arg))
			return curr;
	}
	return NULL;
}

