//
//
//	Amachi parser Add-on
//
//										(C) JoOl 1998


#include "AmachiAddOn.h"



PlainAddOn*
NewAmachiAddOn()
{
	return new AmachiAddOn();
}


AmachiAddOn::AmachiAddOn()
: PlainAddOn()
{
	name = NULL;
	version = NULL;
	author = NULL;
	email = NULL;
	constructor = NULL;
}


AmachiAddOn::AmachiAddOn(char* path)
: PlainAddOn()
{
	name = NULL;
	version = NULL;
	author = NULL;
	email = NULL;
	constructor = NULL;

	SetTo(path);
}


AmachiAddOn::~AmachiAddOn()
{
}


ParserConstructor
AmachiAddOn::GetConstructor() const
{
	return constructor;
}


bool
AmachiAddOn::SetTo(char* p)
{
	if (!PlainAddOn::SetTo(p))
		return false;

	if (get_image_symbol(image, "handlerName", B_SYMBOL_TYPE_DATA, &name) != B_OK)
		return false;
	if (get_image_symbol(image, "handlerVersion", B_SYMBOL_TYPE_DATA, &version) != B_OK)
		return false;
	if (get_image_symbol(image, "handlerAuthor", B_SYMBOL_TYPE_DATA, &author) != B_OK)
		return false;
	if (get_image_symbol(image, "handlerEmail", B_SYMBOL_TYPE_DATA, &email) != B_OK)
		return false;
	if (get_image_symbol(image, "instantiate_parser", B_SYMBOL_TYPE_TEXT, &constructor) != B_OK)
		return false;

	SetId((char* )name);

	float			len = be_plain_font->StringWidth(name);
	longestString = name;
	if (be_plain_font->StringWidth(version) > len)
		longestString = version;
	if (be_plain_font->StringWidth(author) > len)
		longestString = author;
	if (be_plain_font->StringWidth(email) > len)
		longestString = email;

	return true;
}



void
AmachiAddOn::DrawString(BView* owner, BFont* font, float x, float y,
						const char* string1, const char* string2)
{
	if (string2)
	{
		owner->SetHighColor(40, 40, 200);
		owner->MovePenTo(BPoint(x, y));
		owner->DrawString(string1);

		owner->MovePenTo(BPoint(x + max_c(font->StringWidth(string1), AMACHI_ADDON_SPACE2), y));
		owner->SetHighColor(0, 0, 0);
		owner->DrawString(string2);
	}
	else
	{
		owner->SetHighColor(200, 0, 0);
		owner->MovePenTo(BPoint(x, y));
		owner->DrawString(string1);
	}
}


void
AmachiAddOn::DrawItem(BView* owner, BRect itemRect, bool drawEverything)
{
	BFont			font;
	owner->GetFont(&font);
	owner->SetFont(be_plain_font);

	owner->SetDrawingMode(B_OP_COPY);
	if (IsSelected())
		owner->SetHighColor(200, 200, 200, 0);
	else
		owner->SetHighColor(viewColor);
//		owner->SetHighColor(owner->ViewColor());
	owner->FillRect(itemRect);

	if (!IsEnabled())
		owner->SetHighColor(150, 150, 150, 0);
	else
		owner->SetHighColor(0, 0, 0, 0);

	// draws the label
	float			xoffset = itemRect.left + 2.0;
	float			yoffset = itemRect.top + 12.0;

	DrawString(owner, &font, xoffset, yoffset, GetLabel());

	// other strings
	xoffset = itemRect.left + 20.0 + max_c(font.StringWidth(GetLabel()), AMACHI_ADDON_SPACE1);

	DrawString(owner, &font, xoffset, yoffset, "name: ", name);
	yoffset += 12.0;
	DrawString(owner, &font, xoffset, yoffset, "version: ", version);
	yoffset += 12.0;
	DrawString(owner, &font, xoffset, yoffset, "author: ", author);
	yoffset += 12.0;
	DrawString(owner, &font, xoffset, yoffset, "contact: ", email);
}


void
AmachiAddOn::Update(BView* owner, const BFont* font)
{
	SetHeight(4.0 * 12.0 + 4.0);
	SetWidth(AMACHI_ADDON_SPACE1 + AMACHI_ADDON_SPACE2 + font->StringWidth(longestString));
}

