//
//
//	Am@chi info window
//
//											(C) JoOl 1998


#include <Application.h>
#include <Window.h>
#include <View.h>
#include <Bitmap.h>
#include <Path.h>
#include <Entry.h>
#include <TranslationUtils.h>
#include "AmachiInfoWindow.h"



InfoView::InfoView(BBitmap* b, BRect fr, const char* n, uint32 rm, uint32 f)
:BView(fr, n, rm, f),
 bmp(b)
{
}


InfoView::~InfoView()
{
	if (bmp)
		delete bmp;
}


void
InfoView::Draw(BRect updateRect)
{
	if (bmp)
		DrawBitmap(bmp, BPoint(0.0, 0.0));
}




AmachiInfoWindow::AmachiInfoWindow(BRect frame, const char* name, window_look look,
								window_feel feel, uint32 flags, uint32 wkspaces)
:BWindow(frame, name, look, feel, flags, wkspaces)
{
	BPath				appPath;
	app_info			appInfo;
	be_app->GetAppInfo(&appInfo);
	BEntry				appEntry(&appInfo.ref, true);
	appEntry.GetPath(&appPath);
	appPath.GetParent(&appPath);

	BPath				bmpPath;
	BBitmap*			bmp;
	bmpPath.SetTo(appPath.Path());
	bmpPath.Append("art/about.gif");
	bmp = BTranslationUtils::GetBitmapFile(bmpPath.Path());


	BRect			fr = Bounds();
	bg = new InfoView(bmp, fr, "bg", B_FOLLOW_ALL, B_WILL_DRAW);
	bg->SetViewColor(220, 220, 220, 0);
	this->AddChild(bg);
}


AmachiInfoWindow::~AmachiInfoWindow()
{
}


bool
AmachiInfoWindow::QuitRequested()
{
	if (!IsHidden())
		Hide();

	return false;
}
