//
//
//	Am@chi loaders window
//
//											(C) JoOl 1998


#include <Application.h>
#include <Window.h>
#include <View.h>

#include "LoadersWindow.h"
#include "LAPerrors.h"


LoadersWindow::LoadersWindow(BRect frame, const char* name, window_look look,
							window_feel feel, uint32 flags, uint32 wkspaces)
: BWindow(frame, name, look, feel, flags, wkspaces)
{
	BRect			fr;

	// window's background view
	fr = Bounds();
	BView*				bgv = new BView(fr, "loadersWindow_bg", B_FOLLOW_ALL,
										B_WILL_DRAW | B_FRAME_EVENTS);
	bgv->SetViewColor(220, 220, 220, 0);
	this->AddChild(bgv);

	fr = Bounds();
	BView*				lv = new BView(fr, "loaderList",
										B_FOLLOW_ALL,
										B_WILL_DRAW | B_FRAME_EVENTS);
	loadersRoster = new LoadersRoster(lv, "loadersRoster", IL_SCROLL_ALL);
	bgv->AddChild(loadersRoster);

	SetSizeLimits(100.0, 300.0, 100.0, 450.0);
}


LoadersWindow::~LoadersWindow()
{
}


LoadersRoster*
LoadersWindow::GetLoadersRoster() const
{
	return loadersRoster;
}

/*
void
LoadersWindow::StopLoaders()
{
	loadersRoster->StopLoaders();
}
*/

bool
LoadersWindow::QuitRequested()
{
	if (!IsHidden())
		Hide();
//	loadersRoster->StopLoaders();

	return false;
}


void
LoadersWindow::MessageReceived(BMessage* msg)
{
	if (msg->HasRef("refs"))
	{
		be_app->RefsReceived(msg);
		return;
	}
printf("LoadersWindow::MessageReceived / %d\n", msg->what);
	BWindow::MessageReceived(msg);
}
