//
//
//	Add-ons roster
//
//											(C) JoOl 1998


#ifndef _ADD_ONS_ROSTER_H_
#define _ADD_ONS_ROSTER_H_


#include "PlainAddOn.h"
#include "RitemsList.h"


typedef PlainAddOn*		(*AddOnConstructor)();
typedef bool			(*AddOnFilter)(PlainAddOn* , void* );


class					AddOnsRoster: public RitemsList
{
public:
						AddOnsRoster(BListView* , const char* , uint32 = IL_NO_SCROLL);
						~AddOnsRoster();

	int32				CountItems() const;
	PlainAddOn*			ItemAt(int32 ) const;
	static int32		cmpPlainAddOns(Pitem* , void* );
	static int32		cmpPlainAddOnRefs(Pitem* , void* );
	static int32		cmpPlainAddOnNodeRefs(Pitem* , void* );

	// unload add-ons
	void				Reset();

	// insert an add-on file
	bool				Insert(entry_ref , AddOnConstructor );
	bool				Insert(BEntry , AddOnConstructor );
	bool				Insert(const char* , AddOnConstructor );
	bool				DoInsert(const char* , AddOnConstructor );

	// remove an add-on file (call triggered  by the node monitor, most likely)
	PlainAddOn*			Remove(node_ref );
	PlainAddOn*			Remove(entry_ref );
	bool				Delete(node_ref );
	bool				Delete(entry_ref );

	// provide an environment variable name
	bool				SetFromEnv(const char* , AddOnConstructor );
	// provide a directory to explore (no "deep" parse)
	bool				Explore(const char* , AddOnConstructor );

	// returns the add-on which fulfills the condition described in the filter
	PlainAddOn*			Filter(AddOnFilter , void* ) const;
};


#endif /* _ADD_ONS_ROSTER_H_ */

