//
//
//	Am@chi application
//
//											(C) JoOl 1998


#ifndef _AMACHI_APP_H_
#define _AMACHI_APP_H_


#include <Application.h>
#include <Path.h>
#include "AmachiDefs.h"
#include "AmachiInfoWindow.h"
#include "AmachiWindow.h"
#include "SetupWindow.h"
#include "LoadersWindow.h"
#include "MessagesWindow.h"
#include "AmachiGLWindow.h"


#define APP_SIGNATURE "application/x-vnd.JoOl-Amachi"
#define APP_PREFS_FILENAME "Amachi_settings"


class						AmachiApp : public BApplication
{
	//
	BPath					appPath;
	GLconfig				defaultRenderParams;

	void					ReadPrefs();
	void					WritePrefs();
	void					UsePrefs(BMessage& );
	void					SetFrame(BWindow* , const BRect& );

	LAPtracer*				messagesOutput;

	// info window
	AmachiInfoWindow*		infoWin;

	// main window data
	AmachiWindow*			amachiWin;
	ScenesRoster*			scenesRoster;

	// messages window
	MessagesWindow*			messagesWin;
	MessagesRoster*			messagesRoster;

	// loaders window data
	LoadersWindow*			loadersWin;
	LoadersRoster*			loadersRoster;
	int32					parserBlockSize;

	// setup window data
	SetupWindow*			setupWin;
	AddOnsRoster*			addonsRoster;

	// OpenGL window
	AmachiGLWindow*			glWin;

	void					LoadIcons();
	void					HideWindow(int32 ) const;
	void					HideAllWindows() const;
	void					ShowWindow(int32 ) const;
	void					ShowAllWindows() const;
	void					QuitWindow(BWindow* );

public:
							AmachiApp();
	virtual					~AmachiApp();

	VloaderItem*			FindHandlerFor(entry_ref );
	static bool				AddonCanHandleFile(PlainAddOn* , void* );

	virtual void			MessageReceived(BMessage* );
	virtual void			RefsReceived(BMessage* );
	virtual bool			QuitRequested();
};


#endif /* _AMACHI_APPLI_H_ */

