//
//
//	CD buttons
//
//											(C) JoOl 1998


#ifndef _CD_BUTTONS_H_
#define _CD_BUTTONS_H_


#include <Button.h>


class						CdButton : public BButton
{
protected:
	uint32					value;

	BRect					ButtonBounds();

	BMessage*				msgOn;
	BMessage*				msgOff;

public:
							CdButton(BRect , char* ,
									uint32 = B_FOLLOW_LEFT | B_FOLLOW_TOP,
									uint32 = B_WILL_DRAW);
	virtual					~CdButton();

	void					SetMessages(BMessage* , BMessage* , BHandler* );

	virtual void			Draw(BRect ) = 0;
	virtual void			MouseDown(BPoint );
	void					SetButtonValue(int32 );
};


// play & pause toggle button
class						CdPlayPauseButton: public CdButton
{
protected:
public:
							CdPlayPauseButton(BRect , char* ,
									uint32 = B_FOLLOW_LEFT | B_FOLLOW_TOP,
									uint32 = B_WILL_DRAW);
	virtual					~CdPlayPauseButton();

	virtual void			Draw(BRect );
};


// stop button
class						CdStopButton: public CdButton
{
protected:
public:
							CdStopButton(BRect , char* ,
									uint32 = B_FOLLOW_LEFT | B_FOLLOW_TOP,
									uint32 = B_WILL_DRAW);
	virtual					~CdStopButton();

	virtual void			Draw(BRect );
};


// kill button
class						CdKillButton: public CdButton
{
protected:
public:
							CdKillButton(BRect , char* ,
									uint32 = B_FOLLOW_LEFT | B_FOLLOW_TOP,
									uint32 = B_WILL_DRAW);
	virtual					~CdKillButton();

	virtual void			Draw(BRect );
};



#endif /* _CD_BUTTONS_H_ */

