//
//
//	3DS objects parser
//
//										(C) JoOl 1998


#ifndef _PARSER_3DS_H_
#define _PARSER_3DS_H_


#include "LAPbinParser.h"
#include "LAPlexemeTable.h"

#include "PierrotParser.h"
#include "PierrotColor.h"


// Main chunk
enum
{
	MAIN_3DS				= 0x4d4d,		// 3ds binary files
	MAIN_MLI				= 0x3daa,		// Material library files
	MAIN_PRJ				= 0x3dc2		// 3ds project file
};

// Sub chunks of MAIN3DS
enum
{
	EDIT3DS					= 0x3d3d,
	KEYF3DS					= 0xb000
};

// Sub chunks of EDIT3DS
enum
{
	EDIT_MATERIAL			= 0xafff,
	EDIT_CONFIG1			= 0x0100,
	EDIT_CONFIG2			= 0x3e3d,
	EDIT_VIEW_P1			= 0x7012,
	EDIT_VIEW_P2			= 0x7011,
	EDIT_VIEW_P3			= 0x7020,
	EDIT_VIEW1				= 0x7001,
	EDIT_BACKGR				= 0x1200,
	EDIT_AMBIENT			= 0x2100,
	EDIT_OBJECT				= 0x4000,

	EDIT_UNKNOWN01			= 0x1100,
	EDIT_UNKNOWN02			= 0x1201,
	EDIT_UNKNOWN03			= 0x1300,
	EDIT_UNKNOWN04			= 0x1400,
	EDIT_UNKNOWN05			= 0x1420,
	EDIT_UNKNOWN06			= 0x1450,
	EDIT_UNKNOWN07			= 0x1500,
	EDIT_UNKNOWN08			= 0x2200,
	EDIT_UNKNOWN09			= 0x2201,
	EDIT_UNKNOWN10			= 0x2210,
	EDIT_UNKNOWN11			= 0x2300,
	EDIT_UNKNOWN12			= 0x2302,
	EDIT_UNKNOWN13			= 0x3000
};

// Sub chunks of EDIT_MATERIAL
enum
{
	MAT_NAME				= 0xa000,
	MAT_AMBIENTCOLOR		= 0xa010,
	MAT_DIFFUSECOLOR		= 0xa020,
	MAT_SPECULARCOLOR		= 0xa030,
	MAT_SHININESS			= 0xa040,
	MAT_TRANSPARENCY		= 0xa050,
	MAT_TRANSFALLOFF		= 0xa052,
	MAT_REFLECTBLUR			= 0xa053,
	MAT_TEXTUREMAP			= 0xa200,
	MAT_OPACITYMAP			= 0xa210,
	MAT_TRANSFOFFENABLE		= 0xa240,
	MAT_REFLBLURENABLE		= 0xa250,
	MAT_BUMPMAP				= 0xa230,
	MAT_MAPFILE				= 0xa300
};

// Sub chunks of EDIT_OBJECT
enum
{
	OBJ_TRIMESH				= 0x4100,
	OBJ_LIGHT				= 0x4600,
	OBJ_CAMERA				= 0x4700,

	OBJ_UNKNOWN1			= 0x4010,
	OBJ_UNKNOWN2			= 0x4012			// shadow ?
};

// Sub chunks of OBJ_CAMERA
enum
{
	CAM_UNKNOWN1			= 0x4710,
	CAM_UNKNOWN2			= 0x4720
};

// Sub chunks of OBJ_LIGHT
enum
{
	LIGHT_OFF				= 0x4620,
	LIGHT_SPOT				= 0x4610,
	LIGHT_INNER_RANGE		= 0x4659,
	LIGHT_OUTER_RANGE		= 0x465a,
	LIGHT_MULTIPLIER		= 0x465b
};

// Sub chunks of OBJ_TRIMESH
enum
{
	TRI_VERTLIST			= 0x4110,
	TRI_FACELIST2			= 0x4111,
	TRI_FACELIST			= 0x4120,
	TRI_MATERIAL			= 0x4130,
	TRI_MAPCOORD			= 0x4140,
	TRI_SMOOTH				= 0x4150,
	TRI_LOCALAXIS			= 0x4160,
	TRI_VISIBLE				= 0x4165,
	TRI_MAPPINGSTD			= 0x4170
};


// Sub chunks of KEYF3DS
enum
{
	KEYF_UNKNOWN1			= 0xb009,
	KEYF_UNKNOWN2			= 0xb00a,
	KEYF_FRAMES				= 0xb008,
	KEYF_OBJDESCR			= 0xb002
};


// Sub chunks of KEYF_OBJDESCR
enum
{
	ODES_NAMHIER			= 0xb010,
	ODES_DUMMYNAME			= 0xb011,
	ODES_UNKNOWN2			= 0xb013,
	ODES_UNKNOWN3			= 0xb014,
	ODES_UNKNOWN4			= 0xb015,
	ODES_PIVOT				= 0xb020,	// pivot point?
	ODES_UNKNOWN5			= 0xb021,
	ODES_UNKNOWN6			= 0xb022
};


// Color chunks
enum
{
	COLOR_RGBFLOAT			= 0x0010,
	COLOR_RGBBYTE			= 0x0011,
	COLOR_LINE_RGBFLOAT		= 0x0012,
	COLOR_LINE_RGBBYTE		= 0x0013
};

// Viewport chunks
enum
{
	VIEWPORT_TOP			= 0x0001,
	VIEWPORT_BOTTOM			= 0x0002,
	VIEWPORT_LEFT			= 0x0003,
	VIEWPORT_RIGHT			= 0x0004,
	VIEWPORT_FRONT			= 0x0005,
	VIEWPORT_BACK			= 0x0006,
	VIEWPORT_USER			= 0x0007,
	VIEWPORT_CAMERA			= 0xffff,
	VIEWPORT_LIGHT			= 0x0009
};

// misc.
enum
{
	INT_PERCENTAGE			= 0x0030,
	FLOAT_PERCENTAGE		= 0x0031
};


class						Parser3ds : public LAPbinParser, public PierrotParser
{
#define ReadChunkId										\
	uint16			chunkId;							\
	ReadInt16(chunkId)

#define ReadChunkLen									\
	uint32			chunkLen;							\
	ReadInt32(chunkLen)

#define ReadChunk										\
	ReadChunkId;										\
	ReadChunkLen

#define skipChunk										\
	SkipChunk(chunkId, chunkLen)

#define checkChunk(a)															\
	if (currLen != len)															\
		*traceOutput << "*** " << a << " at offset " << lexer->GetPosition()	\
					<< ", currLen = " << currLen << ", " << len << eol

	// private chunks parsing methods
	void					SkipChunk(uint16, uint32);
	void					ReadColorChunk(uint32 , pSpectra& );
	void					ReadRgbFloatChunk(uint32 , pSpectra& );
	void					ReadRgbByteChunk(uint32 , pSpectra& );
	void					ReadAmountChunk(uint32 , float& );

	void					ReadMainChunk(uint32 );
	void					ReadEditChunk(uint32 );
	void					ReadKeyfChunk(uint32 );
		void					ReadObjDesc(uint32 );
			void					ReadHierarchy(uint32 , char* , int16& );
			void					ReadDummyName(uint32 , char* );
//		void					ReadFrames(uint32 );
	void					ReadEditMaterialChunk(uint32 );
		void					ReadMaterialName(uint32 , char* );
	void					ReadBackgroundChunk(uint32 );
	void					ReadAmbientChunk(uint32 );

	void					ReadObjectChunk(uint32 );
		void					ReadTriMeshChunk(uint32 , char* );
			void					ReadVerticesChunk(uint32 , pObject* );
			void					ReadTransfoChunk(uint32 , pObject* );
			void					ReadFacesChunk(uint32 , pObject* );
				void					ReadFaceMaterialChunk(uint32 , pObject* );
//				void					ReadFaceSmoothChunk(uint32 , uint16 , pObject* );
		void					ReadLightChunk(uint32 , char* );
			void					ReadSpotChunk(uint32 , pPoint3& , float& , float& );
		void					ReadCameraChunk(uint32 );

	LAPlexemeTable			lexemes;
	void					SetLexemes();
	const char*				GetLexeme(LAPtoken );

	virtual status_t		_Identify();
	virtual status_t		_Parse();
	virtual void			_Terminate();
	virtual status_t		DoAbort();

	pMaterial*				defaultMaterial;
	void					CheckMaterials();

public:

							Parser3ds(int32 , LAPtracer* );
	virtual					~Parser3ds();
};



#if __POWERPC__
#pragma export on
#endif
extern "C" Parser3ds*		instantiate_parser(int32 , LAPtracer* );
#if __POWERPC__
#pragma export reset
#endif



#endif	/* _PARSER_3DS_H_ */

