//
//
//	AOFF objects parser
//
//												(C) 1998 JoOl


#include "ParserAoff.h"
#include "ParserGeom.h"
#include "ParserIpcol.h"



#if __POWERPC__
#pragma export on
#endif
char			handlerName[]		= "OFF v1.0 (.aoff)";
char			handlerVersion[]	= "1.1.0";
char			handlerAuthor[]		= "Alain GAUTHEROT";
char			handlerEmail[]		= "gauthero@club-internet.fr";
#if __POWERPC__
#pragma export reset
#endif



ParserAoff*
instantiate_parser(int32 bs)
{
	return new ParserAoff(bs);
}


ParserAoff::ParserAoff(int32 blockSize)
: LAPtextParser()
{
	SetLexer(new LexerAoff(max_c(1024, blockSize), new LAPlexemeBuffer(128, true)));

	SetTo(new LAPtracer(128, LAP_BUFFER_OUTPUT_ON_OVERFLOW, LAP_BUFFER_SCREEN_OUTPUT),
			new LAPtextBufferedOutput(128, LAP_BUFFER_OUTPUT_ON_OVERFLOW, LAP_BUFFER_NO_OUTPUT/*LAP_BUFFER_SCREEN_OUTPUT*/),
			new LAPdisplay(),
			LAP_OWN_ERROR_OUTPUT | LAP_OWN_TRACE_OUTPUT | LAP_OWN_DISPLAY);
}


ParserAoff::~ParserAoff()
{
	if (data)
		delete (pScene* )data;
}


status_t
ParserAoff::DoAbort()
{
	PierrotParser::Reset();
	return LAP_NO_ERROR;
}


status_t
ParserAoff::_Identify()
{
	bool		silent = traceOutput->IsSilent();
	traceOutput->SetSilent(true);

	Match(TOKEN_NAME);

	traceOutput->SetSilent(silent);

	return LAP_NO_ERROR;
}


status_t
ParserAoff::_Parse()
{
	bool				isCcw = true;

	PierrotParser::Reset();

	scene = new pScene((char* )GetLexer()->GetInputName(),
						2, 2,					// lights
						16, 16,					// materials
						16, 16);				// objects

	pMaterial*			defaultMaterial = NewMaterial("default material");
	defaultMaterial->ambient.Set(0.1, 0.1, 0.1);
	defaultMaterial->diffuse.Set(0.4, 0.4, 0.4);
	defaultMaterial->specular.Set(0.5, 0.5, 0.5);
	defaultMaterial->shininess = 40.0;

	while (!Peek(LAP_TOKEN_EOF))
	{
		if (Peek(TOKEN_GEOMETRY))
			ParseGeometry();
		else if (Peek(TOKEN_POLYGON_COLORS))
			ParseColors();
		else if (Peek(TOKEN_VERTEX_ORDER))
			ParseVertexOrder(isCcw);
		else
			SkipLine();
	}

	if (!isCcw)
		scene->ReverseFaces();

	pSphere				normSphere(pPoint3(0.0, 0.0, 0.0), 1.0);
	scene->Preprocess(&normSphere, appliInterface, 0.0, 1.0);

	scene->ambient.Set(0.6, 0.6, 0.6);
	if (scene->lights.CountItems() == 0)
	{
		pLight*			l = NewDirectionalLight("directional light 1", pVector3(-0.5, 0.5, 0.8));
		l->ambient.Set(0.2, 0.2, 0.2);
		l->diffuse.Set(1.0, 1.0, 1.0);
		l->specular.Set(1.0, 1.0, 1.0);
	}

	Output(*traceOutput, scene, PRINT_LIGHT_ALL | PRINT_MATERIAL_ALL |
			PRINT_OBJECT_BOUNDS | PRINT_OBJECT_MATRIX | PRINT_OBJECT_POINTS);

	data = scene;
	scene = NULL;

	return LAP_NO_ERROR;
}


status_t
ParserAoff::GetFileRef(char* fname, entry_ref* outRef)
{
	BPath				inputPath;
	BEntry				inputEntry(&lexer->GetInputRef(), false);
	inputEntry.GetPath(&inputPath);
	inputPath.GetParent(&inputPath);
	inputPath.Append(fname);

	status_t			status;

	inputEntry.SetTo(inputPath.Path());
	status = inputEntry.InitCheck();
	if (status != B_NO_ERROR)
		return status;
	if (!inputEntry.Exists())
		return B_ENTRY_NOT_FOUND;

	status = inputEntry.GetRef(outRef);
	if (status != B_NO_ERROR)
		return status;

	return B_NO_ERROR;
}


void
ParserAoff::ParseGeometry()
{
	Match(TOKEN_GEOMETRY);
	Match(TOKEN_INDEXED_POLY);
	Match(TOKEN_FFF);
	SkipSpaces();
	char*						filename = LexWord();

	entry_ref			geomRef;
	status_t			stat = GetFileRef(filename, &geomRef);
	if (stat != B_NO_ERROR)
		throw LAPfileException(LAP_CANT_OPEN_FILE, "ParserAoff::ParseGeometry",
								filename);
	*traceOutput << "geometry in " << filename << '/' << geomRef.name << eol;
	delete[] filename;

	ParserGeom*					geomParser = new ParserGeom(1024, this, scene);
	if (geomParser->SetInput(geomRef, LAP_NO_TRACE) == LAP_NO_ERROR)
	{
		geomParser->Parse();
		geomParser->Terminate();
	}
	delete geomParser;
	errorOutput->SetHeader(lexer->GetInputName(), lexer->GetLineNumberPointer());
}


void
ParserAoff::ParseColors()
{
	Match(TOKEN_POLYGON_COLORS);

	if (Peek(TOKEN_DEFAULT))
	{
		Match(TOKEN_DEFAULT);
		Match(TOKEN_FFF);
		int32				matIndex = scene->materials.Search("default material");
		pMaterial*			defaultMaterial = scene->materials[matIndex];
		ParseFloat(defaultMaterial->diffuse.r);
		ParseFloat(defaultMaterial->diffuse.g);
		ParseFloat(defaultMaterial->diffuse.b);
		defaultMaterial->ambient = defaultMaterial->diffuse;
		defaultMaterial->specular.Set(0.7, 0.7, 0.7);
		defaultMaterial->shininess = 60.0;

		*traceOutput << "color by default: ";
		Output(*traceOutput, defaultMaterial->diffuse);
		*traceOutput << eol;
	}
	else
	{
		if (Peek(TOKEN_GENERIC))
			Match(TOKEN_GENERIC);
		else
			Match(TOKEN_INDEXED);
		Match(TOKEN_FFF);
		Match(LAP_TOKEN_IDENTIFIER);
		char*				filename = lexer->DetachStringLiteral();
		entry_ref			colorsRef;
		status_t			stat = GetFileRef(filename, &colorsRef);
		if (stat != B_NO_ERROR)
			throw LAPfileException(LAP_CANT_OPEN_FILE, "ParserAoff::ParseColors",
									filename);
		*traceOutput << "colors in " << filename << '/' << colorsRef.name << eol;

		ParserIpcol*				colParser = new ParserIpcol(1024, this, scene);
		if (colParser->SetInput(colorsRef, LAP_NO_TRACE) == LAP_NO_ERROR)
		{
			colParser->Parse();
			colParser->Terminate();
		}
		delete colParser;
		delete[] filename;

		errorOutput->SetHeader(lexer->GetInputName(), lexer->GetLineNumberPointer());
	}
}


void
ParserAoff::ParseVertexOrder(bool& isCcw)
{
	Match(TOKEN_VERTEX_ORDER);
	Match(TOKEN_DEFAULT);
	Match(TOKEN_S);
	if (Peek(TOKEN_CLOCKWISE))
	{
		Match(TOKEN_CLOCKWISE);
		isCcw = false;
	}
	else
	{
		Match(TOKEN_COUNTER_CLOCKWISE);
		isCcw = true;
	}
}
