//
//
//	NFF-WTK lexer class
//
//											(C) JoOl 1998


#include "LexerNffWtk.h"



LexerNffWtk::LexerNffWtk(int32 blen, LAPlexemeBuffer* lb)
: LAPtextLexer(blen, lb)
{
}


LexerNffWtk::~LexerNffWtk()
{
}


void
LexerNffWtk::SetCharCodes()
{
	SetDefaultCharCodes();
	SetCharCode(0xd, LAP_CHAR_SPACE);
	SetCharCode('.', LAP_CHAR_ALPHA);
}


void
LexerNffWtk::SetLexemes()
{
	lexemes.Insert(new LAPlexeme("nff", TOKEN_NFF));
	lexemes.Insert(new LAPlexeme("s8", TOKEN_S8));
		lexemes.Insert(new LAPlexeme("version", TOKEN_VERSION));
		lexemes.Insert(new LAPlexeme("viewpos", TOKEN_VIEWPOS));
		lexemes.Insert(new LAPlexeme("viewdir", TOKEN_VIEWDIR));
	lexemes.Insert(new LAPlexeme("norm", TOKEN_NORM));
	lexemes.Insert(new LAPlexeme("rgb", TOKEN_RGB));
	lexemes.Insert(new LAPlexeme("uv", TOKEN_UV));
	lexemes.Insert(new LAPlexeme("both", TOKEN_BOTH));
}


LAPtoken
LexerNffWtk::_NextToken()
{
	for (;;)
	{
		if (input->Eof())
			return LAP_TOKEN_EOF;

		char			currentCharacter = input->Peek();

		// deal with numbers (both positive and negative integers or floats)
		if (IsDigit(currentCharacter) || (currentCharacter == '.'))
		{
			LexNumber();
			return token;
		}
		if (currentCharacter == '-')
		{
			Fwd();
			LexNumber();
			return token;
		}

		// deal with identifiers and lexemes
		if (IsAlpha(currentCharacter))
		{
			LexIdentifier();
			return token;
		}

		// deal with spaces
		if (IsSpace(currentCharacter))
		{
			SkipSpaces();
			continue;
		}

		if (currentCharacter == '/')
		{
			Skip();
			if (input->Peek() != '/')
				throw LAPillegalCharacter("LexerNffWtk::_NextToken", '/');
			else
			{
				SkipLine();
				continue;
			}
		}

		ProcessIllegal(currentCharacter);
	}
}

