//
//
//	OBJ lexer class
//
//										(C) JoOl 1998


#include "LexerObj.h"
#include "TokensObj.h"



LexerObj::LexerObj(int32 blen, LAPlexemeBuffer* lb)
: LAPtextLexer(blen, lb)
{
}


LexerObj::~LexerObj()
{
}


void
LexerObj::SetLexemes()
{
	lexemes.Insert(new LAPlexeme("v", TOKEN_V));
	lexemes.Insert(new LAPlexeme("vt", TOKEN_VTEXTURE));
	lexemes.Insert(new LAPlexeme("vn", TOKEN_VNORMAL));
	lexemes.Insert(new LAPlexeme("vp", TOKEN_VPARAM));
	lexemes.Insert(new LAPlexeme("cstype", TOKEN_CSTYPE));
		lexemes.Insert(new LAPlexeme("rat", TOKEN_RAT));
		lexemes.Insert(new LAPlexeme("bmatrix", TOKEN_BMATRIX));
		lexemes.Insert(new LAPlexeme("bezier", TOKEN_BEZIER));
		lexemes.Insert(new LAPlexeme("bspline", TOKEN_BSPLINE));
		lexemes.Insert(new LAPlexeme("cardinal", TOKEN_CARDINAL));
		lexemes.Insert(new LAPlexeme("taylor", TOKEN_TAYLOR));
	lexemes.Insert(new LAPlexeme("deg", TOKEN_DEGREE));
	lexemes.Insert(new LAPlexeme("bmat_u", TOKEN_BMATU));
	lexemes.Insert(new LAPlexeme("bmat_v", TOKEN_BMATV));
	lexemes.Insert(new LAPlexeme("step", TOKEN_STEP));

	lexemes.Insert(new LAPlexeme("p", TOKEN_POINT));
	lexemes.Insert(new LAPlexeme("l", TOKEN_LINE));
	lexemes.Insert(new LAPlexeme("f", TOKEN_FACE));
	lexemes.Insert(new LAPlexeme("fo", TOKEN_FACE));		// for compatibility
	lexemes.Insert(new LAPlexeme("curv", TOKEN_CURVE));
	lexemes.Insert(new LAPlexeme("curv2", TOKEN_CURVE2D));
	lexemes.Insert(new LAPlexeme("surf", TOKEN_SURFACE));

	lexemes.Insert(new LAPlexeme("parm_u", TOKEN_PARAMU));
	lexemes.Insert(new LAPlexeme("parm_v", TOKEN_PARAMV));
	lexemes.Insert(new LAPlexeme("trim", TOKEN_TRIM));
	lexemes.Insert(new LAPlexeme("hole", TOKEN_HOLE));
	lexemes.Insert(new LAPlexeme("scrv", TOKEN_SCURVE));
	lexemes.Insert(new LAPlexeme("sp", TOKEN_SPOINT));
	lexemes.Insert(new LAPlexeme("end", TOKEN_ENDSTMT));

	lexemes.Insert(new LAPlexeme("con", TOKEN_CONNECT));

	lexemes.Insert(new LAPlexeme("g", TOKEN_GROUPNAME));
	lexemes.Insert(new LAPlexeme("s", TOKEN_SMOOTHGROUP));
	lexemes.Insert(new LAPlexeme("mg", TOKEN_MERGEGROUP));
	lexemes.Insert(new LAPlexeme("o", TOKEN_OBJECTNAME));

	lexemes.Insert(new LAPlexeme("bevel", TOKEN_BEVELINTERP));
	lexemes.Insert(new LAPlexeme("c_interp", TOKEN_CINTERP));
	lexemes.Insert(new LAPlexeme("d_interp", TOKEN_DINTERP));

	lexemes.Insert(new LAPlexeme("lod", TOKEN_LOD));
	lexemes.Insert(new LAPlexeme("maplib", TOKEN_MAPLIB));
	lexemes.Insert(new LAPlexeme("usemap", TOKEN_USEMAP));
	lexemes.Insert(new LAPlexeme("usemtl", TOKEN_USEMATERIAL));
	lexemes.Insert(new LAPlexeme("mtllib", TOKEN_MATLIB));
	lexemes.Insert(new LAPlexeme("shadow_obj", TOKEN_SHADOW));
	lexemes.Insert(new LAPlexeme("trace_obj", TOKEN_TRACE));
	lexemes.Insert(new LAPlexeme("ctech", TOKEN_CTECH));
	lexemes.Insert(new LAPlexeme("stech", TOKEN_STECH));
		lexemes.Insert(new LAPlexeme("cparm", TOKEN_CPARM));
		lexemes.Insert(new LAPlexeme("cspace", TOKEN_CSPACE));
		lexemes.Insert(new LAPlexeme("cparma", TOKEN_CPARMA));
		lexemes.Insert(new LAPlexeme("cparmb", TOKEN_CPARMB));

	lexemes.Insert(new LAPlexeme("bsp", TOKEN_BSP));
	lexemes.Insert(new LAPlexeme("bzp", TOKEN_BZP));
	lexemes.Insert(new LAPlexeme("cdc", TOKEN_CDC));
	lexemes.Insert(new LAPlexeme("cdp", TOKEN_CDP));
	lexemes.Insert(new LAPlexeme("res", TOKEN_RES));
}


LAPtoken
LexerObj::_NextToken()
{
	for (;;)
	{
		if (input->Eof())
			return LAP_TOKEN_EOF;

		char			currentCharacter = input->Peek();

		if (currentCharacter == '/')
		{
			Skip();
			return TOKEN_SLASH;
		}

		// deal with numbers (both positive and negative integers or floats)
		if (IsDigit(currentCharacter) || (currentCharacter == '.'))
		{
			LexNumber();
			return token;
		}
		if (currentCharacter == '-')
		{
			Fwd();
			LexNumber();
			return token;
		}

		// deal with identifiers and lexemes
		if (IsAlpha(currentCharacter))
		{
			LexIdentifier();
			return token;
		}

		// deal with spaces
		if (IsSpace(currentCharacter))
		{
			SkipSpaces();
			continue;
		}

		// deal with comments
		if ((currentCharacter == '#') || (currentCharacter == '$'))
		{
			SkipLine();
			continue;
		}

		ProcessIllegal(currentCharacter);
	}
}

