//
//
//	LAP binary data buffered-input class
//
//											(C) JoOl 1998


#include "LAPimpexp.h"

#include <ByteOrder.h>
#include "LAPbinBufferedInput.h"
#include "LAPerrors.h"



LAPbinBufferedInput::LAPbinBufferedInput(int32 bufSize, LAPendianness e)
: LAPbufferedInput(bufSize)
{
	inputEndianness = e;
}


LAPbinBufferedInput::~LAPbinBufferedInput()
{
}


LAPendianness
LAPbinBufferedInput::GetInputEndianness() const
{
	return inputEndianness;
}


void
LAPbinBufferedInput::SetInputEndianness(LAPendianness oe)
{
	inputEndianness = oe;
}


bool
LAPbinBufferedInput::IsInputBigEndian() const
{
	return inputEndianness == LAP_BIG_ENDIAN;
}


bool
LAPbinBufferedInput::IsInputLittleEndian() const
{
	return inputEndianness == LAP_LITTLE_ENDIAN;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(int8& out)
{
	Read((char* )&out, 1);
	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(uint8& out)
{
	Read((char* )&out, 1);
	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(int16& out)
{
	int16			in;
	Read((char* )&in, sizeof(in));

	out = (inputEndianness == hardwareEndianness)
		? in
		: int16((uint16(in) << 8) | (uint16(in) >> 8));
/*
	out = (inputEndianness == LAP_LITTLE_ENDIAN)
		? B_LENDIAN_TO_HOST_INT16(in)
		: B_BENDIAN_TO_HOST_INT16(in);
*/	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(uint16& out)
{
	int16			in;
	Read((char* )&in, sizeof(in));

	out = (inputEndianness == hardwareEndianness)
		? in
		: uint16((uint16(in) << 8) | (uint16(in) >> 8));
/*	out = (inputEndianness == LAP_LITTLE_ENDIAN)
		? B_LENDIAN_TO_HOST_INT16(in)
		: B_BENDIAN_TO_HOST_INT16(in);
*/	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(int32& out)
{
	int32			in;
	Read((char* )&in, sizeof(in));
	out = (inputEndianness == LAP_LITTLE_ENDIAN)
		? B_LENDIAN_TO_HOST_INT32(in)
		: B_BENDIAN_TO_HOST_INT32(in);
	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(uint32& out)
{
	int32			in;
	Read((char* )&in, sizeof(in));
	out = (inputEndianness == LAP_LITTLE_ENDIAN)
		? B_LENDIAN_TO_HOST_INT32(in)
		: B_BENDIAN_TO_HOST_INT32(in);
	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(int64& out)
{
	int64			in;
	Read((char* )&in, sizeof(in));
	out = (inputEndianness == LAP_LITTLE_ENDIAN)
		? B_LENDIAN_TO_HOST_INT64(in)
		: B_BENDIAN_TO_HOST_INT64(in);
	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(uint64& out)
{
	int64			in;
	Read((char* )&in, sizeof(in));
	out = (inputEndianness == LAP_LITTLE_ENDIAN)
		? B_LENDIAN_TO_HOST_INT64(in)
		: B_BENDIAN_TO_HOST_INT64(in);
	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(float& out)
{
	float			in;
	Read((char* )&in, sizeof(in));
	out = (inputEndianness == LAP_LITTLE_ENDIAN)
		? B_LENDIAN_TO_HOST_FLOAT(in)
		: B_BENDIAN_TO_HOST_FLOAT(in);
	return *this;
}


LAPbinBufferedInput&
LAPbinBufferedInput::operator>>(double& out)
{
	double			in;
	Read((char* )&in, sizeof(in));
	out = (inputEndianness == LAP_LITTLE_ENDIAN)
		? B_LENDIAN_TO_HOST_DOUBLE(in)
		: B_BENDIAN_TO_HOST_DOUBLE(in);
	return *this;
}
