//
//
//	LAP binary data buffered-output class
//
//											(C) JoOl 1998


#include "LAPimpexp.h"

#include <ByteOrder.h>
#include "LAPbinBufferedOutput.h"
#include "LAPerrors.h"


LAPbinBufferedOutput::LAPbinBufferedOutput(int32 bufSize, uint8 p, uint8 f, LAPendianness e)
: LAPbufferedOutput(bufSize, p, f)
{
	outputEndianness = e;
}


LAPbinBufferedOutput::~LAPbinBufferedOutput()
{
	*this << flush;
}


LAPendianness
LAPbinBufferedOutput::GetOutputEndianness() const
{
	return outputEndianness;
}


void
LAPbinBufferedOutput::SetOutputEndianness(LAPendianness oe)
{
	outputEndianness = oe;
}


bool
LAPbinBufferedOutput::IsOutputBigEndian() const
{
	return outputEndianness == LAP_BIG_ENDIAN;
}


bool
LAPbinBufferedOutput::IsOutputLittleEndian() const
{
	return outputEndianness == LAP_LITTLE_ENDIAN;
}


LAPbinBufferedOutput&
LAPbinBufferedOutput::operator<<(int8 In)
{
	if (!silent)
		Append((char* )&In, 1);
	return *this;
}


LAPbinBufferedOutput&
LAPbinBufferedOutput::operator<<(int16 In)
{
	if (!silent)
	{
		// workaround for swap_int16 not exported in Intel libroot.so ?
		int16			Out;
		Out = (outputEndianness == hardwareEndianness)
			? In
			: int16((uint16(In) << 8) | (uint16(In) >> 8));
		Append((char* )&Out, sizeof(In));

/*		int16			Out;
		Out = (outputEndianness == LAP_LITTLE_ENDIAN)
			? B_HOST_TO_LENDIAN_INT16(In)
			: B_HOST_TO_BENDIAN_INT16(In);
		Append((char* )&Out, sizeof(In));
*/	}
	return *this;
}


LAPbinBufferedOutput&
LAPbinBufferedOutput::operator<<(int32 In)
{
	if (!silent)
	{
		int32			Out;
		Out = (outputEndianness == LAP_LITTLE_ENDIAN)
			? B_HOST_TO_LENDIAN_INT32(In)
			: B_HOST_TO_BENDIAN_INT32(In);
		Append((char* )&Out, sizeof(In));
	}
	return *this;
}


LAPbinBufferedOutput&
LAPbinBufferedOutput::operator<<(int64& In)
{
	if (!silent)
	{
		int64			Out;
		Out = (outputEndianness == LAP_LITTLE_ENDIAN)
			? B_HOST_TO_LENDIAN_INT64(In)
			: B_HOST_TO_BENDIAN_INT64(In);
		Append((char* )&Out, sizeof(In));
	}
	return *this;
}


LAPbinBufferedOutput&
LAPbinBufferedOutput::operator<<(float In)
{
	if (!silent)
	{
		float			Out;
		Out = (outputEndianness == LAP_LITTLE_ENDIAN)
			? B_HOST_TO_LENDIAN_FLOAT(In)
			: B_HOST_TO_BENDIAN_FLOAT(In);
		Append((char* )&Out, sizeof(In));
	}
	return *this;
}


LAPbinBufferedOutput&
LAPbinBufferedOutput::operator<<(double& In)
{
	if (!silent)
	{
		double			Out;
		Out = (outputEndianness == LAP_LITTLE_ENDIAN)
			? B_HOST_TO_LENDIAN_DOUBLE(In)
			: B_HOST_TO_BENDIAN_DOUBLE(In);
		Append((char* )&Out, sizeof(In));
	}
	return *this;
}


LAPbinBufferedOutput&
LAPbinBufferedOutput::operator<<(char* Str)
{
	if (!silent)
	{
		if (!Str)
			Append("<nil>", 5);
		else
			Append(Str, strlen(Str));
	}
	return *this;
}


LAPbinBufferedOutput&
LAPbinBufferedOutput::operator<<(LAPbufferFlush& /*eb*/)
{
	int32			len;
	char*			ptr = (char* )GetBuffer(len);
	if ((!silent) && (len > 0))
	{
		Output(ptr, len);
	}
	Reset();
	return *this;
}


status_t
LAPbinBufferedOutput::OutputScreen(char* str, int32 len)
{
//printf("<");
/*	if (msgType == LAP_ERROR_MESSAGE)
		printf("error: ");
	else if (msgType == LAP_WARNING_MESSAGE)
		printf("warning: ");
	else if (msgType == LAP_INFO_MESSAGE)
		printf("info: ");
*/
	int32		WorkSize = LAP_BUFFER_WORK_LEN >> 1;
	while (len > 0)
	{
		uint8*		PtrOut = (uint8* )tmp;
		int32		CurrLen;
		if (len < WorkSize)
			CurrLen = len;
		else
			CurrLen = WorkSize;
		for (int32 i = 0; i < CurrLen; i++)
		{
			uint8		c = uint8(*str) >> 4;
			*PtrOut++ = (c > 9)?(c-10+'A'):(c+'0');
			c = uint8(*str) & 0xf;
			*PtrOut++ = (c > 9)?(c-10+'A'):(c+'0');
			str++;
		}
		*PtrOut = 0;
		printf("%s", tmp);
		len -= CurrLen;
	}
//	printf(">\n");
	printf("\n");
	return LAP_NO_ERROR;
}

