//
//
//	LAP statically-allocated buffer class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include <new.h>
#include "LAPbuffer.h"
#include "LAPmemoryException.h"
#include "LAPerrors.h"


LAPbuffer::LAPbuffer(int32 blen)
{
	buffer = NULL;
	readPtr = writePtr = 0;
	SetSize(blen);

	int16			test = 0x1234;
	hardwareEndianness = (*(int8* )&test == 0x12) ? LAP_BIG_ENDIAN : LAP_LITTLE_ENDIAN;
}


LAPbuffer::~LAPbuffer()
{
	delete[] buffer;
}


void
LAPbuffer::SetSize(int32 bLen)
{
	if (buffer)
		delete[] buffer;
	blockSize = (bLen > LAP_BUFFER_BLOCK_LEN) ? bLen : LAP_BUFFER_BLOCK_LEN;

	Alloc(blockSize);
	status = LAP_NO_ERROR;
}


void
LAPbuffer::Alloc(int32 len)
{
	try
	{
		alloc = 0;
		buffer = new char[len+1];
		readPtr = writePtr = 0;
		alloc = len;
	}
	catch (bad_alloc )
	{
		throw LAPbadAlloc("LAPbuffer::Alloc", "buffer", len+1);
	}
}


void
LAPbuffer::_badWrite(char* /*str*/, int32 len)
{
	throw LAPbadBufferWrite("LAPbuffer::badWrite", "buffer", len, alloc - writePtr);
}


void
LAPbuffer::badWrite(char* str, int32 len)
{
	_badWrite(str, len);
}


void
LAPbuffer::_badRead(char* /*str*/, int32 len)
{
	throw LAPbadBufferRead("LAPbuffer::badRead", "buffer", len, writePtr - readPtr);
}


void
LAPbuffer::badRead(char* str, int32 len)
{
	_badRead(str, len);
}


status_t
LAPbuffer::GetStatus() const
{
	return status;
}


bool
LAPbuffer::CheckStatus() const
{
	return status == LAP_NO_ERROR;
}


bool
LAPbuffer::IsFull() const
{
	return writePtr >= alloc;
}


bool
LAPbuffer::canRead() const
{
	return readPtr < writePtr;
}


bool
LAPbuffer::canWrite() const
{
	return writePtr < alloc;
}


void
LAPbuffer::Reset()
{
	readPtr = writePtr = 0;
}


char*
LAPbuffer::Detach(int32& len)
{
	try
	{
		char*		str = new char[writePtr+1];
		len = writePtr;
		memcpy(str, buffer, writePtr);
		Reset();
		return str;
	}
	catch (bad_alloc )
	{
		throw LAPbadAlloc("LAPbuffer::Detach", "str", writePtr+1);
		return NULL;			// for compile-warning only
	}
}


const char*
LAPbuffer::GetBuffer(int32& len) const
{
	len = writePtr;
	return buffer;
}


int32
LAPbuffer::GetLength() const
{
	return writePtr;
}


int32
LAPbuffer::GetAlloc() const
{
	return alloc;
}


void
LAPbuffer::Append(char* str, int32 len)
{
	if (writePtr + len > alloc)
	{
		badWrite(str, len);
		return ;
	}

	memcpy(&buffer[writePtr], str, len);
	writePtr += len;
}


void
LAPbuffer::AppendWhatFits(char*& str, int32& len)
{
	int32		NbBytes = min_c(alloc - writePtr, len);
	if (NbBytes < 1)
		return ;

	memcpy(&buffer[writePtr], str, NbBytes);
	writePtr += NbBytes;
	str += NbBytes;
	len -= NbBytes;
}


void
LAPbuffer::Read(char* str, int32 len)
{
	if (readPtr + len > writePtr)
	{
		badRead(str, len);
		return ;
	}
	memcpy(str, &buffer[readPtr], len);
	readPtr += len;
}


void
LAPbuffer::Read(char& out)
{
	if (readPtr + 1 > writePtr)
	{
		badRead(&out, 1);
		return ;
	}
	out = buffer[readPtr++];
}


void
LAPbuffer::ReadWhatsLeft(char*& str, int32& len)
{
	int32		NbBytes = min_c(writePtr - readPtr, len);
	if (NbBytes < 1)
		return ;

	memcpy(str, &buffer[readPtr], NbBytes);
	readPtr += NbBytes;
	str += NbBytes;
	len -= NbBytes;
}
